/*
 * Decompiled with CFR 0.152.
 */
package com.kpouer.mapview.marker;

import com.kpouer.mapview.MapView;
import java.awt.AWTEventMulticaster;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;

public abstract class Marker {
    protected double longitude;
    protected double latitude;
    protected int x;
    protected int y;
    protected Color color;
    private MouseListener mouseListener;
    private MouseMotionListener mouseMotionListener;
    private boolean draggable;

    protected Marker(double latitude, double longitude, Color color) {
        this.longitude = longitude;
        this.latitude = latitude;
        this.color = color;
    }

    public void addMouseListener(MouseListener mouseListener) {
        this.mouseListener = AWTEventMulticaster.add(this.mouseListener, mouseListener);
    }

    public void removeMouseListener(MouseListener mouseListener) {
        AWTEventMulticaster.remove(this.mouseListener, mouseListener);
    }

    public void addMouseMotionListener(MouseMotionListener mouseMotionListener) {
        this.mouseMotionListener = AWTEventMulticaster.add(this.mouseMotionListener, mouseMotionListener);
    }

    public void removeMouseMotionListener(MouseMotionListener mouseMotionListener) {
        AWTEventMulticaster.remove(this.mouseMotionListener, mouseMotionListener);
    }

    public void processMouseEvent(MouseEvent e) {
        e.setSource(this);
        MouseListener listener = this.mouseListener;
        if (listener != null) {
            int id = e.getID();
            switch (id) {
                case 501: {
                    listener.mousePressed(e);
                    break;
                }
                case 502: {
                    listener.mouseReleased(e);
                    break;
                }
                case 500: {
                    listener.mouseClicked(e);
                    break;
                }
                case 505: {
                    listener.mouseExited(e);
                    break;
                }
                case 504: {
                    listener.mouseEntered(e);
                }
            }
        }
    }

    public void processMouseMotionEvent(MouseEvent e) {
        e.setSource(this);
        MouseMotionListener listener = this.mouseMotionListener;
        if (listener != null) {
            int id = e.getID();
            switch (id) {
                case 506: {
                    listener.mouseDragged(e);
                    break;
                }
                case 503: {
                    listener.mouseMoved(e);
                }
            }
        }
    }

    public void setLocation(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public abstract void paint(Graphics var1);

    public abstract boolean contains(Point var1);

    public void computeLocation(MapView mapView) {
        int x = mapView.longitudeToPointScreen(this.longitude);
        int y = mapView.latitudeToPointScreen(this.latitude);
        this.setLocation(x, y);
    }

    public double getLongitude() {
        return this.longitude;
    }

    public double getLatitude() {
        return this.latitude;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public Color getColor() {
        return this.color;
    }

    public MouseListener getMouseListener() {
        return this.mouseListener;
    }

    public MouseMotionListener getMouseMotionListener() {
        return this.mouseMotionListener;
    }

    public boolean isDraggable() {
        return this.draggable;
    }

    public void setLongitude(double longitude) {
        this.longitude = longitude;
    }

    public void setLatitude(double latitude) {
        this.latitude = latitude;
    }

    public void setX(int x) {
        this.x = x;
    }

    public void setY(int y) {
        this.y = y;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public void setMouseListener(MouseListener mouseListener) {
        this.mouseListener = mouseListener;
    }

    public void setMouseMotionListener(MouseMotionListener mouseMotionListener) {
        this.mouseMotionListener = mouseMotionListener;
    }

    public void setDraggable(boolean draggable) {
        this.draggable = draggable;
    }
}

