/*
 * Decompiled with CFR 0.152.
 */
package com.kpouer.mapview.marker;

import com.kpouer.mapview.MapView;
import com.kpouer.mapview.marker.Marker;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.RenderingHints;

public class PolygonMarker
extends Marker {
    private final com.kpouer.wkt.shape.Polygon polygon;
    private final int[] xpoints;
    private final int[] ypoints;
    private final int width;
    private Color borderColor;
    private boolean filled;

    public PolygonMarker(com.kpouer.wkt.shape.Polygon polygon, int width, Color color, boolean filled) {
        super(polygon.getBarycenter().getY(), polygon.getBarycenter().getX(), color);
        this.polygon = polygon;
        this.xpoints = new int[polygon.getNpoints()];
        this.ypoints = new int[polygon.getNpoints()];
        this.width = width;
        this.borderColor = new Color(color.getRed(), color.getGreen(), color.getBlue(), 255);
        this.filled = filled;
    }

    @Override
    public void paint(Graphics g) {
        g.setColor(this.color);
        Graphics2D graphics2D = (Graphics2D)g;
        graphics2D.setStroke(new BasicStroke(this.width));
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (this.filled) {
            g.fillPolygon(this.xpoints, this.ypoints, this.xpoints.length);
            g.setColor(this.borderColor);
            g.drawPolygon(this.xpoints, this.ypoints, this.xpoints.length);
        } else {
            g.drawPolygon(this.xpoints, this.ypoints, this.xpoints.length);
        }
    }

    @Override
    public boolean contains(Point e) {
        Polygon tmpPolygon = new Polygon(this.xpoints, this.ypoints, this.xpoints.length);
        return tmpPolygon.contains(e.x, e.y);
    }

    @Override
    public void computeLocation(MapView mapView) {
        super.computeLocation(mapView);
        int x = 0;
        int y = 0;
        for (int i = 0; i < this.xpoints.length; ++i) {
            this.xpoints[i] = mapView.longitudeToPointScreen(this.polygon.getXpoints()[i]);
            this.ypoints[i] = mapView.latitudeToPointScreen(this.polygon.getYpoints()[i]);
            x += this.xpoints[i];
            y += this.ypoints[i];
        }
        this.setLocation(x / this.xpoints.length, y / this.ypoints.length);
    }

    public void setBorderColor(Color borderColor) {
        this.borderColor = borderColor;
    }

    public Color getBorderColor() {
        return this.borderColor;
    }

    public void setFilled(boolean filled) {
        this.filled = filled;
    }

    public boolean isFilled() {
        return this.filled;
    }
}

