/*
 * Decompiled with CFR 0.152.
 */
package com.kpouer.mapview.marker;

import com.kpouer.mapview.marker.Marker;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;

public class Rectangle
extends Marker {
    private int width;
    private int height;

    public Rectangle(double latitude, double longitude, int width, int height, Color color) {
        super(latitude, longitude, color);
        this.width = width;
        this.height = height;
    }

    @Override
    public void paint(Graphics g) {
        g.setColor(this.getColor());
        g.fillRect(this.x - this.width / 2, this.y - this.height / 2, this.width, this.height);
    }

    @Override
    public boolean contains(Point point) {
        return point.getX() >= (double)(this.x - this.width / 2) && point.getX() < (double)(this.x + this.width / 2) && point.getY() >= (double)(this.y - this.height / 2) && point.getY() < (double)(this.y + this.height / 2);
    }

    public String toString() {
        return "Rectangle{longitude=" + this.longitude + ", latitude=" + this.latitude + ", x=" + this.x + ", y=" + this.y + ", width=" + this.width + ", height=" + this.height + ", color=" + this.color + "}";
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public void setHeight(int height) {
        this.height = height;
    }
}

