/*
 * Decompiled with CFR 0.152.
 */
package com.kpouer.mapview.tile;

import com.kpouer.mapview.tile.Tile;
import com.kpouer.mapview.tile.TileServer;
import com.kpouer.mapview.tile.cache.ImageCache;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.imageio.ImageIO;
import org.jetbrains.annotations.Nullable;

public class DefaultTileServer
implements TileServer {
    private final int tilesSize;
    private final int minZoom;
    private final int maxZoom;
    private final ImageCache imageCache;
    private final String[] urlPatterns;
    private final ExecutorService executorService;
    private int urlPatternIndex;
    private final Set<Tile> retrieveQueue;

    public DefaultTileServer(int tilesSize, int minZoom, int maxZoom, int threadCount, ImageCache imageCache, String ... urlPatterns) {
        this.tilesSize = tilesSize;
        this.minZoom = minZoom;
        this.maxZoom = maxZoom;
        this.urlPatterns = (String[])urlPatterns.clone();
        this.imageCache = imageCache;
        this.executorService = Executors.newFixedThreadPool(threadCount);
        this.retrieveQueue = new HashSet<Tile>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public Image getTile(int x, int y, int zoom) throws IOException {
        boolean added;
        Tile tile = new Tile(x, y, zoom);
        Image image = this.imageCache.getTile(tile);
        if (image != null) {
            return image;
        }
        Set<Tile> set = this.retrieveQueue;
        synchronized (set) {
            added = this.retrieveQueue.add(tile);
        }
        if (added) {
            this.executorService.submit(() -> {
                block5: {
                    try {
                        if (!this.retrieveQueue.contains(tile)) break block5;
                        String tileUrl = this.getTileUrl(tile);
                        this.imageCache.setTile(tile, DefaultTileServer.getImage(tileUrl));
                        Set<Tile> set = this.retrieveQueue;
                        synchronized (set) {
                            this.retrieveQueue.remove(tile);
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            });
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancelPendingZoom(int zoom) {
        Set<Tile> set = this.retrieveQueue;
        synchronized (set) {
            this.retrieveQueue.removeIf(tile -> tile.getZoom() != zoom);
        }
    }

    private static Image getImage(String urlString) throws IOException {
        URL url = new URL(urlString);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestProperty("User-Agent", "K-Mapview");
        conn.setRequestMethod("GET");
        try (BufferedInputStream inputStream = new BufferedInputStream(conn.getInputStream());){
            BufferedImage bufferedImage = ImageIO.read(inputStream);
            return bufferedImage;
        }
    }

    @Override
    public int getTilesSize() {
        return this.tilesSize;
    }

    @Override
    public int getMinZoom() {
        return this.minZoom;
    }

    @Override
    public int getMaxZoom() {
        return this.maxZoom;
    }

    private String getTileUrl(Tile tile) {
        String nextUrlPattern = this.urlPatterns[this.urlPatternIndex++ % this.urlPatterns.length];
        return nextUrlPattern.replace("${z}", Integer.toString(tile.getZoom())).replace("${x}", Integer.toString(tile.getX())).replace("${y}", Integer.toString(tile.getY()));
    }
}

