/*
 * Decompiled with CFR 0.152.
 */
package com.kpouer.mapview.tile.cache;

import com.kpouer.mapview.tile.Tile;
import com.kpouer.mapview.tile.cache.ImageCache;
import java.awt.Image;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.imageio.ImageIO;
import org.jetbrains.annotations.Nullable;

public class ImageCacheImpl
implements ImageCache {
    private final Map<Tile, Image> map;
    private Path cachePath;

    public ImageCacheImpl(String tileServerName, String cachePath, int capacity) throws IOException {
        if (cachePath != null) {
            this.cachePath = Path.of(cachePath, tileServerName);
            Files.createDirectories(this.cachePath, new FileAttribute[0]);
        }
        this.map = new TileImageLinkedHashMap(capacity);
    }

    @Override
    @Nullable
    public Image getTile(Tile tile) throws IOException {
        Image image = this.map.get(tile);
        if (image == null && (image = this.getFromDisk(tile)) != null) {
            this.map.put(tile, image);
        }
        return image;
    }

    @Nullable
    private Image getFromDisk(Tile tile) throws IOException {
        if (this.cachePath == null) {
            return null;
        }
        Path keyPath = this.getPath(tile);
        if (Files.exists(keyPath, new LinkOption[0])) {
            return ImageIO.read(keyPath.toFile());
        }
        return null;
    }

    @Override
    public void setTile(Tile tile, Image image) throws IOException {
        this.map.put(tile, image);
        Path path = this.getPath(tile);
        ImageIO.write((RenderedImage)((Object)image), "png", path.toFile());
    }

    private Path getPath(Tile tile) {
        return this.cachePath.resolve(tile.getKey() + ".png");
    }

    private static class TileImageLinkedHashMap
    extends LinkedHashMap<Tile, Image> {
        private final int capacity;

        TileImageLinkedHashMap(int capacity) {
            super(capacity + 1);
            this.capacity = capacity;
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<Tile, Image> eldest) {
            return this.size() > this.capacity;
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TileImageLinkedHashMap)) {
                return false;
            }
            TileImageLinkedHashMap other = (TileImageLinkedHashMap)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            return this.capacity == other.capacity;
        }

        protected boolean canEqual(Object other) {
            return other instanceof TileImageLinkedHashMap;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            result = result * 59 + this.capacity;
            return result;
        }
    }
}

