/*
 * Decompiled with CFR 0.152.
 */
package com.kpouer.roadwork.action;

import com.kpouer.roadwork.configuration.Config;
import com.kpouer.roadwork.service.LocalizationService;
import com.kpouer.roadwork.service.SoftwareModel;
import com.kpouer.roadwork.ui.dialog.SynchronizationSettingsDialog;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.lang.Nullable;
import org.springframework.stereotype.Component;

@Component
public class SynchronizationSettingsAction
extends AbstractAction {
    private final SoftwareModel softwareModel;
    private final Config config;
    private final ApplicationEventPublisher applicationEventPublisher;

    public SynchronizationSettingsAction(SoftwareModel softwareModel, Config config, ApplicationEventPublisher applicationEventPublisher, LocalizationService localizationService) {
        super(localizationService.getMessage("action.synchronizationSettings"));
        this.softwareModel = softwareModel;
        this.config = config;
        this.applicationEventPublisher = applicationEventPublisher;
    }

    @Override
    public void actionPerformed(@Nullable ActionEvent e) {
        EventQueue.invokeLater(() -> {
            SynchronizationSettingsDialog dialog = new SynchronizationSettingsDialog(this.softwareModel, this.config, this.applicationEventPublisher);
            dialog.setLocationRelativeTo(this.softwareModel.getMainFrame());
            dialog.setVisible(true);
        });
    }
}

