/*
 * Decompiled with CFR 0.152.
 */
package com.kpouer.roadwork.action;

import com.kpouer.mapview.MapView;
import com.kpouer.roadwork.configuration.Config;
import com.kpouer.roadwork.configuration.UserSettings;
import com.kpouer.roadwork.model.RoadworkData;
import com.kpouer.roadwork.service.LocalizationService;
import com.kpouer.roadwork.service.OpendataServiceManager;
import com.kpouer.roadwork.service.SoftwareModel;
import com.kpouer.roadwork.service.SynchronizationService;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class SynchronizeAction
extends AbstractAction {
    private static final Logger logger = LoggerFactory.getLogger(SynchronizeAction.class);
    private final SynchronizationService synchronizationService;
    private final Config config;
    private final MapView mapView;
    private final SoftwareModel softwareModel;
    private final OpendataServiceManager opendataServiceManager;

    public SynchronizeAction(SynchronizationService synchronizationService, Config config, MapView mapView, SoftwareModel softwareModel, LocalizationService localizationService, OpendataServiceManager opendataServiceManager) {
        super(localizationService.getMessage("action.synchronize"));
        this.synchronizationService = synchronizationService;
        this.config = config;
        this.mapView = mapView;
        this.softwareModel = softwareModel;
        this.opendataServiceManager = opendataServiceManager;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        logger.info("synchronize");
        UserSettings userSettings = this.config.getUserSettings();
        if (userSettings.isSynchronizationEnabled()) {
            RoadworkData roadworkData = this.softwareModel.getRoadworkData();
            this.synchronizationService.synchronize(roadworkData);
            this.opendataServiceManager.save(roadworkData);
            this.mapView.repaint();
        }
    }
}

