/*
 * Decompiled with CFR 0.152.
 */
package com.kpouer.roadwork.action;

import com.kpouer.roadwork.model.Roadwork;
import com.kpouer.roadwork.service.OpendataServiceManager;
import com.kpouer.roadwork.service.SoftwareModel;
import com.kpouer.roadwork.service.exception.OpenDataException;
import java.awt.Desktop;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;
import org.springframework.lang.Nullable;
import org.springframework.stereotype.Component;

@Component
public class WmeAction
extends AbstractAction {
    public static final String DEFAULT_WME_URL = "https://waze.com/fr/editor?env=row&lat=${lat}&&lon=${lon}&zoomLevel=19";
    private final SoftwareModel softwareModel;
    private final OpendataServiceManager opendataServiceManager;

    public WmeAction(SoftwareModel softwareModel, OpendataServiceManager opendataServiceManager) {
        super("WME");
        this.softwareModel = softwareModel;
        this.opendataServiceManager = opendataServiceManager;
    }

    @Override
    public void actionPerformed(@Nullable ActionEvent e) {
        Roadwork selectedRoadwork = this.softwareModel.getRoadwork();
        if (selectedRoadwork != null && Desktop.isDesktopSupported() && Desktop.getDesktop().isSupported(Desktop.Action.BROWSE)) {
            try {
                Desktop.getDesktop().browse(this.getWmeUrl(selectedRoadwork));
            }
            catch (OpenDataException | IOException | URISyntaxException ex) {
                JOptionPane.showMessageDialog(this.softwareModel.getMainFrame(), ex.getMessage());
            }
        }
    }

    private URI getWmeUrl(Roadwork roadwork) throws URISyntaxException, OpenDataException {
        String url = this.opendataServiceManager.getOpendataService().getMetadata().getEditorPattern();
        if (url == null) {
            url = DEFAULT_WME_URL;
        }
        return new URI(url.replace("${lat}", String.valueOf(roadwork.getLatitude())).replace("${lon}", String.valueOf(roadwork.getLongitude())));
    }
}

