/*
 * Decompiled with CFR 0.152.
 */
package com.kpouer.roadwork.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.kpouer.mapview.marker.Circle;
import com.kpouer.mapview.marker.Marker;
import com.kpouer.mapview.marker.PolygonMarker;
import com.kpouer.roadwork.model.sync.Status;
import com.kpouer.roadwork.model.sync.SyncData;
import com.kpouer.wkt.shape.Polygon;
import java.awt.Color;
import java.util.Arrays;
import org.springframework.lang.NonNull;

@JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
public class Roadwork {
    @NonNull
    private String id;
    private double latitude;
    private double longitude;
    private Polygon[] polygons;
    private long start;
    private long end;
    private String road;
    private String locationDetails;
    private String impactCirculationDetail;
    private String description;
    @JsonIgnore
    private Marker[] markers;
    private SyncData syncData;
    private String url;

    public void updateStatus(Status status) {
        this.syncData.updateStatus(status);
        this.updateMarker();
    }

    public void updateMarker() {
        if (this.markers != null) {
            for (Marker marker : this.markers) {
                Color color = this.getColor();
                if (marker instanceof PolygonMarker) {
                    color = new Color((float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f, 0.5f);
                }
                marker.setColor(color);
            }
        }
    }

    @JsonIgnore
    public Marker[] getMarker() {
        if (this.markers == null) {
            if (this.polygons != null) {
                this.markers = new Marker[this.polygons.length];
                for (int i = 0; i < this.polygons.length; ++i) {
                    Polygon polygon = this.polygons[i];
                    Color color = this.getColor();
                    this.markers[i] = new PolygonMarker(polygon, 2, color, true);
                }
                this.updateMarker();
            } else {
                this.markers = new Marker[1];
                this.markers[0] = new Circle(this.latitude, this.longitude, 5, this.getColor());
            }
        }
        return this.markers;
    }

    @JsonIgnore
    private Color getColor() {
        switch (this.getSyncData().getStatus()) {
            case New: {
                return Color.RED;
            }
            case Treated: {
                return Color.GREEN;
            }
            case Ignored: {
                return Color.YELLOW;
            }
            case Later: {
                return Color.BLUE;
            }
            case Finished: {
                return Color.GRAY;
            }
        }
        throw new RuntimeException("Unexpected status " + this.start);
    }

    public boolean isExpired() {
        return this.end < System.currentTimeMillis();
    }

    public String toString() {
        return "Roadwork[" + this.id + "]";
    }

    public static RoadworkBuilder builder() {
        return new RoadworkBuilder();
    }

    @NonNull
    public String getId() {
        return this.id;
    }

    public double getLatitude() {
        return this.latitude;
    }

    public double getLongitude() {
        return this.longitude;
    }

    public Polygon[] getPolygons() {
        return this.polygons;
    }

    public long getStart() {
        return this.start;
    }

    public long getEnd() {
        return this.end;
    }

    public String getRoad() {
        return this.road;
    }

    public String getLocationDetails() {
        return this.locationDetails;
    }

    public String getImpactCirculationDetail() {
        return this.impactCirculationDetail;
    }

    public String getDescription() {
        return this.description;
    }

    public Marker[] getMarkers() {
        return this.markers;
    }

    public SyncData getSyncData() {
        return this.syncData;
    }

    public String getUrl() {
        return this.url;
    }

    public void setId(@NonNull String id) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        this.id = id;
    }

    public void setLatitude(double latitude) {
        this.latitude = latitude;
    }

    public void setLongitude(double longitude) {
        this.longitude = longitude;
    }

    public void setPolygons(Polygon[] polygons) {
        this.polygons = polygons;
    }

    public void setStart(long start) {
        this.start = start;
    }

    public void setEnd(long end) {
        this.end = end;
    }

    public void setRoad(String road) {
        this.road = road;
    }

    public void setLocationDetails(String locationDetails) {
        this.locationDetails = locationDetails;
    }

    public void setImpactCirculationDetail(String impactCirculationDetail) {
        this.impactCirculationDetail = impactCirculationDetail;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @JsonIgnore
    public void setMarkers(Marker[] markers) {
        this.markers = markers;
    }

    public void setSyncData(SyncData syncData) {
        this.syncData = syncData;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public Roadwork(@NonNull String id, double latitude, double longitude, Polygon[] polygons, long start, long end, String road, String locationDetails, String impactCirculationDetail, String description, Marker[] markers, SyncData syncData, String url) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        this.id = id;
        this.latitude = latitude;
        this.longitude = longitude;
        this.polygons = polygons;
        this.start = start;
        this.end = end;
        this.road = road;
        this.locationDetails = locationDetails;
        this.impactCirculationDetail = impactCirculationDetail;
        this.description = description;
        this.markers = markers;
        this.syncData = syncData;
        this.url = url;
    }

    public Roadwork() {
    }

    public static class RoadworkBuilder {
        private String id;
        private double latitude;
        private double longitude;
        private Polygon[] polygons;
        private long start;
        private long end;
        private String road;
        private String locationDetails;
        private String impactCirculationDetail;
        private String description;
        private Marker[] markers;
        private SyncData syncData;
        private String url;

        RoadworkBuilder() {
        }

        public RoadworkBuilder id(@NonNull String id) {
            this.id = id;
            return this;
        }

        public RoadworkBuilder latitude(double latitude) {
            this.latitude = latitude;
            return this;
        }

        public RoadworkBuilder longitude(double longitude) {
            this.longitude = longitude;
            return this;
        }

        public RoadworkBuilder polygons(Polygon[] polygons) {
            this.polygons = polygons;
            return this;
        }

        public RoadworkBuilder start(long start) {
            this.start = start;
            return this;
        }

        public RoadworkBuilder end(long end) {
            this.end = end;
            return this;
        }

        public RoadworkBuilder road(String road) {
            this.road = road;
            return this;
        }

        public RoadworkBuilder locationDetails(String locationDetails) {
            this.locationDetails = locationDetails;
            return this;
        }

        public RoadworkBuilder impactCirculationDetail(String impactCirculationDetail) {
            this.impactCirculationDetail = impactCirculationDetail;
            return this;
        }

        public RoadworkBuilder description(String description) {
            this.description = description;
            return this;
        }

        @JsonIgnore
        public RoadworkBuilder markers(Marker[] markers) {
            this.markers = markers;
            return this;
        }

        public RoadworkBuilder syncData(SyncData syncData) {
            this.syncData = syncData;
            return this;
        }

        public RoadworkBuilder url(String url) {
            this.url = url;
            return this;
        }

        public Roadwork build() {
            return new Roadwork(this.id, this.latitude, this.longitude, this.polygons, this.start, this.end, this.road, this.locationDetails, this.impactCirculationDetail, this.description, this.markers, this.syncData, this.url);
        }

        public String toString() {
            return "Roadwork.RoadworkBuilder(id=" + this.id + ", latitude=" + this.latitude + ", longitude=" + this.longitude + ", polygons=" + Arrays.deepToString(this.polygons) + ", start=" + this.start + ", end=" + this.end + ", road=" + this.road + ", locationDetails=" + this.locationDetails + ", impactCirculationDetail=" + this.impactCirculationDetail + ", description=" + this.description + ", markers=" + Arrays.deepToString(this.markers) + ", syncData=" + this.syncData + ", url=" + this.url + ")";
        }
    }
}

