/*
 * Decompiled with CFR 0.152.
 */
package com.kpouer.roadwork.model;

import com.kpouer.roadwork.model.Roadwork;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.springframework.lang.NonNull;

public class RoadworkData
implements Iterable<Roadwork> {
    private String source;
    private Map<String, Roadwork> roadworks;
    private long created;

    public RoadworkData(String source, Collection<Roadwork> roadworks) {
        this.source = source;
        this.roadworks = new HashMap<String, Roadwork>(roadworks.size());
        roadworks.forEach(roadwork -> this.roadworks.put(roadwork.getId(), (Roadwork)roadwork));
        this.created = System.currentTimeMillis();
    }

    @Override
    @NonNull
    public Iterator<Roadwork> iterator() {
        return this.roadworks.values().iterator();
    }

    public Roadwork getRoadwork(String id) {
        return this.roadworks.get(id);
    }

    public RoadworkData() {
    }

    public String getSource() {
        return this.source;
    }

    public Map<String, Roadwork> getRoadworks() {
        return this.roadworks;
    }

    public long getCreated() {
        return this.created;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public void setRoadworks(Map<String, Roadwork> roadworks) {
        this.roadworks = roadworks;
    }

    public void setCreated(long created) {
        this.created = created;
    }
}

