/*
 * Decompiled with CFR 0.152.
 */
package com.kpouer.roadwork.opendata;

import com.kpouer.roadwork.model.Roadwork;
import com.kpouer.roadwork.model.RoadworkData;
import com.kpouer.roadwork.opendata.OpendataResponse;
import com.kpouer.roadwork.opendata.OpendataService;
import com.kpouer.roadwork.opendata.json.model.Metadata;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.MediaType;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.lang.Nullable;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;

public abstract class AbstractOpendataService<R, E extends OpendataResponse<R>>
implements OpendataService {
    private static final Logger logger = LoggerFactory.getLogger(AbstractOpendataService.class);
    private final Class<E> responseType;
    private final RestTemplate restTemplate;
    private final Metadata metadata;

    @Override
    public Optional<RoadworkData> getData() throws RestClientException {
        logger.info("getData from {} -> {}", (Object)this.metadata.getUrl(), (Object)this.responseType);
        ArrayList messageConverters = new ArrayList();
        MappingJackson2HttpMessageConverter converter = new MappingJackson2HttpMessageConverter();
        converter.setSupportedMediaTypes(Collections.singletonList(MediaType.ALL));
        messageConverters.add(converter);
        this.restTemplate.setMessageConverters(messageConverters);
        OpendataResponse response = (OpendataResponse)this.restTemplate.getForObject(this.metadata.getUrl(), this.responseType, new Object[0]);
        if (response == null) {
            logger.debug("No data");
            return Optional.empty();
        }
        logger.info("Data retrieved");
        return Optional.of(this.getRoadworkData(response));
    }

    protected RoadworkData getRoadworkData(E opendataResponse) {
        logger.info("getRoadworkData {}", (Object)opendataResponse);
        long deadline = System.currentTimeMillis() + 604800000L;
        List<Roadwork> roadworks = opendataResponse.parallelStream().map(this::getRoadwork).filter(Objects::nonNull).filter(roadwork -> roadwork.getEnd() == 0L || roadwork.getEnd() > deadline).toList();
        return new RoadworkData(this.getClass().getSimpleName(), roadworks);
    }

    @Nullable
    protected abstract Roadwork getRoadwork(R var1);

    public AbstractOpendataService(Class<E> responseType, RestTemplate restTemplate, Metadata metadata) {
        this.responseType = responseType;
        this.restTemplate = restTemplate;
        this.metadata = metadata;
    }

    @Override
    public Metadata getMetadata() {
        return this.metadata;
    }
}

