/*
 * Decompiled with CFR 0.152.
 */
package com.kpouer.roadwork.service;

import com.kpouer.roadwork.action.SynchronizationSettingsAction;
import com.kpouer.roadwork.configuration.Config;
import com.kpouer.roadwork.configuration.UserSettings;
import com.kpouer.roadwork.event.SynchronizationSettingsUpdated;
import com.kpouer.roadwork.model.Roadwork;
import com.kpouer.roadwork.model.RoadworkData;
import com.kpouer.roadwork.model.sync.SyncData;
import com.kpouer.roadwork.service.LocalizationService;
import com.kpouer.roadwork.service.SoftwareModel;
import java.net.ConnectException;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JOptionPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Service;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;

@Service
public class SynchronizationService {
    private static final Logger logger = LoggerFactory.getLogger(SynchronizationService.class);
    private final UserSettings userSettings;
    private final LocalizationService localizationService;
    private final SoftwareModel softwareModel;
    private final ApplicationEventPublisher applicationEventPublisher;
    private final ApplicationContext applicationContext;

    public SynchronizationService(Config config, LocalizationService localizationService, SoftwareModel softwareModel, ApplicationEventPublisher applicationEventPublisher, ApplicationContext applicationContext) {
        this.userSettings = config.getUserSettings();
        this.localizationService = localizationService;
        this.softwareModel = softwareModel;
        this.applicationEventPublisher = applicationEventPublisher;
        this.applicationContext = applicationContext;
    }

    public void synchronize(RoadworkData roadworkData) {
        if (this.userSettings.isSynchronizationEnabled()) {
            logger.info("synchronize");
            String url = this.getUrl(roadworkData.getSource());
            logger.info("Will synchronize with url {}", (Object)url);
            RestTemplate restTemplate = new RestTemplate();
            try {
                HashMap<String, SyncData> body = new HashMap<String, SyncData>();
                for (Roadwork roadwork : roadworkData) {
                    body.put(roadwork.getId(), roadwork.getSyncData());
                }
                MapParameterizedTypeReference responseType = new MapParameterizedTypeReference();
                HttpEntity entity = new HttpEntity(body, this.createHeaders());
                ResponseEntity<Map<String, SyncData>> roadworkDataResponseEntity = restTemplate.exchange(url, HttpMethod.POST, entity, responseType, new Object[0]);
                Map synchronizedData = (Map)roadworkDataResponseEntity.getBody();
                if (synchronizedData == null) {
                    throw new RestClientException("No body in response");
                }
                for (Map.Entry entry : synchronizedData.entrySet()) {
                    SyncData serverSyncData = (SyncData)entry.getValue();
                    Roadwork roadwork = roadworkData.getRoadwork((String)entry.getKey());
                    roadwork.getSyncData().copy(serverSyncData);
                    roadwork.updateMarker();
                }
            }
            catch (HttpClientErrorException.Unauthorized e) {
                logger.warn("Error posting to synchronization server, invalid credencials");
                JOptionPane.showMessageDialog(this.softwareModel.getMainFrame(), this.localizationService.getMessage("dialog.synchronization.unauthorized.message"), this.localizationService.getMessage("dialog.synchronization.unauthorized.title"), 2);
                this.applicationContext.getBean(SynchronizationSettingsAction.class).actionPerformed(null);
            }
            catch (RestClientException e) {
                if (e.getCause() instanceof ConnectException) {
                    logger.error("Unable to connect to synchronization server {}", (Object)url);
                    this.userSettings.setSynchronizationEnabled(false);
                    this.applicationEventPublisher.publishEvent(new SynchronizationSettingsUpdated(this));
                }
                logger.error("Error posting to synchronization server", e);
            }
        }
    }

    @NonNull
    private String getUrl(String source) {
        String synchronizationTeam = this.userSettings.getSynchronizationTeam();
        Object url = this.userSettings.getSynchronizationUrl();
        if (!((String)url).endsWith("/")) {
            url = (String)url + "/";
        }
        url = (String)url + "setData/" + synchronizationTeam + "/" + source;
        return url;
    }

    private HttpHeaders createHeaders() {
        HttpHeaders headers = new HttpHeaders();
        String auth = this.userSettings.getSynchronizationLogin() + ":" + this.userSettings.getSynchronizationPassword();
        String encodedAuth = Base64.getEncoder().encodeToString(auth.getBytes(StandardCharsets.US_ASCII));
        String authHeader = "Basic " + encodedAuth;
        headers.set("Authorization", authHeader);
        return headers;
    }

    private static class MapParameterizedTypeReference
    extends ParameterizedTypeReference<Map<String, SyncData>> {
        private MapParameterizedTypeReference() {
        }
    }
}

