/*
 * Decompiled with CFR 0.152.
 */
package com.kpouer.roadwork.service;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.kpouer.roadwork.configuration.Config;
import com.kpouer.roadwork.model.RoadworkData;
import com.kpouer.roadwork.model.v1.RoadworkDataV1;
import com.kpouer.roadwork.service.RoadworkMigrationService;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Service;

@Service
public class V1RoadworkCacheService
implements RoadworkMigrationService {
    private static final Logger logger = LoggerFactory.getLogger(V1RoadworkCacheService.class);
    private final Config config;

    public V1RoadworkCacheService(Config config) {
        this.config = config;
    }

    @Override
    public Optional<RoadworkData> migrateData() {
        Path pathV1 = this.getPath(this.config.getOpendataService());
        if (Files.exists(pathV1, new LinkOption[0])) {
            ObjectMapper objectMapper = new ObjectMapper();
            objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            try {
                RoadworkDataV1 roadworkDataV1 = objectMapper.readValue(pathV1.toFile(), RoadworkDataV1.class);
                RoadworkData roadworkData = roadworkDataV1.toRoadWork();
                return Optional.of(roadworkData);
            }
            catch (IOException e) {
                logger.error("Unable to read data from {} with {}", (Object)pathV1, (Object)this);
            }
        }
        return Optional.empty();
    }

    @Override
    public void archive() {
        String opendataService = this.config.getOpendataService();
        Path pathV1 = this.getPath(opendataService);
        if (Files.exists(pathV1, new LinkOption[0])) {
            Path archivePath = Path.of(this.config.getDataPath(), opendataService + ".json.bak");
            if (!Files.exists(archivePath, new LinkOption[0])) {
                logger.info("Archiving {} to {}", (Object)pathV1, (Object)archivePath);
                if (!pathV1.toFile().renameTo(archivePath.toFile())) {
                    logger.error("Error renaming archive");
                }
            } else {
                logger.error("Unable to archive to {}, file already exists", (Object)archivePath);
            }
        }
    }

    @NonNull
    private Path getPath(String opendataService) {
        return Path.of(this.config.getDataPath(), opendataService + ".json");
    }
}

