/*
 * Decompiled with CFR 0.152.
 */
package com.kpouer.roadwork.ui;

import com.kpouer.mapview.MapView;
import com.kpouer.mapview.marker.Marker;
import com.kpouer.roadwork.action.ExitAction;
import com.kpouer.roadwork.configuration.Config;
import com.kpouer.roadwork.configuration.UserSettings;
import com.kpouer.roadwork.event.OpendataServiceUpdated;
import com.kpouer.roadwork.event.UserSettingsUpdated;
import com.kpouer.roadwork.model.Roadwork;
import com.kpouer.roadwork.model.RoadworkData;
import com.kpouer.roadwork.model.sync.Status;
import com.kpouer.roadwork.service.OpendataServiceManager;
import com.kpouer.roadwork.service.SoftwareModel;
import com.kpouer.roadwork.service.exception.OpenDataException;
import com.kpouer.roadwork.ui.DetailPanel;
import com.kpouer.roadwork.ui.ToolbarPanel;
import com.kpouer.roadwork.ui.menu.MenuService;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.util.Arrays;
import java.util.Optional;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JSplitPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.event.GenericApplicationListener;
import org.springframework.core.ResolvableType;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestClientException;

@Service
public class MainPanel
extends JFrame
implements GenericApplicationListener {
    private static final Logger logger = LoggerFactory.getLogger(MainPanel.class);
    private final MapView mapView;
    private final DetailPanel detailPanel;
    private final OpendataServiceManager opendataServiceManager;
    private final SoftwareModel softwareModel;
    private final Config config;
    private final ApplicationEventPublisher applicationEventPublisher;

    public MainPanel(final ExitAction exitAction, MapView mapView, MenuService menuService, DetailPanel detailPanel, OpendataServiceManager opendataServiceManager, ToolbarPanel toolbarPanel, SoftwareModel softwareModel, Config config, ApplicationEventPublisher applicationEventPublisher) throws IOException {
        super("Roadwork");
        this.applicationEventPublisher = applicationEventPublisher;
        if ("Mac OS X".equals(System.getProperty("os.name"))) {
            System.setProperty("apple.laf.useScreenMenuBar", "true");
        }
        this.config = config;
        softwareModel.setMainFrame(this);
        this.opendataServiceManager = opendataServiceManager;
        this.softwareModel = softwareModel;
        this.setDefaultCloseOperation(2);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                exitAction.actionPerformed(null);
            }
        });
        this.setJMenuBar(menuService.loadMenu());
        this.getContentPane().add((Component)toolbarPanel, "First");
        this.detailPanel = detailPanel;
        JSplitPane split = new JSplitPane(1, this.detailPanel, mapView);
        this.getContentPane().add(split);
        this.mapView = mapView;
        UserSettings userSettings = config.getUserSettings();
        if (userSettings.getFrameWidth() != 0 && userSettings.getFrameHeight() != 0) {
            this.setBounds(userSettings.getFrameX(), userSettings.getFrameY(), userSettings.getFrameWidth(), userSettings.getFrameHeight());
        } else {
            this.setSize(1024, 768);
        }
        this.setVisible(true);
        EventQueue.invokeLater(this::loadData);
    }

    @Override
    public boolean supportsEventType(ResolvableType eventType) {
        Class<ApplicationEvent> rawClass = eventType.getRawClass();
        return rawClass != null && (rawClass.isAssignableFrom(OpendataServiceUpdated.class) || rawClass.isAssignableFrom(UserSettingsUpdated.class));
    }

    @Override
    public void onApplicationEvent(@NonNull ApplicationEvent event) {
        if (event instanceof OpendataServiceUpdated) {
            this.loadData();
        } else if (event instanceof UserSettingsUpdated) {
            UserSettings userSettings = this.config.getUserSettings();
            this.mapView.removeAllMarkers();
            RoadworkData roadworkData = this.softwareModel.getRoadworkData();
            for (Roadwork roadwork : roadworkData) {
                if (userSettings.isHideExpired() && roadwork.getSyncData().getStatus() == Status.Finished) continue;
                Marker[] markers = roadwork.getMarker();
                Arrays.stream(markers).forEach(this.mapView::addMarker);
            }
            this.mapView.repaint();
        }
    }

    private void loadData() {
        try {
            this.mapView.setTileServer(this.opendataServiceManager.getTileServer());
            this.mapView.setCenter(this.opendataServiceManager.getCenter());
            this.mapView.removeAllMarkers();
            Optional<RoadworkData> roadworkDataOptional = this.opendataServiceManager.getData();
            roadworkDataOptional.ifPresent(this::setRoadworkData);
        }
        catch (OpenDataException e) {
            logger.error("Opendata exception", e);
            this.resetCurrentOpendataService();
            EventQueue.invokeLater(() -> JOptionPane.showMessageDialog(this, e.getMessage(), "Error", 0));
        }
        catch (IOException | RestClientException e) {
            logger.error("Error retrieving data", e);
            EventQueue.invokeLater(() -> JOptionPane.showMessageDialog(this, "Error retrieving data", "Error", 0));
        }
    }

    private void resetCurrentOpendataService() {
        logger.info("resetCurrentOpendataService");
        if (!"France-Paris.json".equals(this.config.getOpendataService())) {
            OpendataServiceUpdated event = new OpendataServiceUpdated(this, this.config.getOpendataService(), "France-Paris.json");
            this.config.setOpendataService("France-Paris.json");
            this.applicationEventPublisher.publishEvent(event);
        }
    }

    private void setRoadworkData(RoadworkData roadworkData) {
        this.softwareModel.setRoadworkData(roadworkData);
        roadworkData.forEach(this::addMarker);
        this.mapView.fitToMarkers();
        this.mapView.repaint();
    }

    private void addMarker(final Roadwork roadwork) {
        MouseAdapter mouseAdapter = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                MainPanel.this.softwareModel.setRoadwork(roadwork);
                MainPanel.this.detailPanel.setRoadwork(roadwork);
            }
        };
        Marker[] markers = roadwork.getMarker();
        Arrays.stream(markers).forEach(arg_0 -> this.lambda$addMarker$2(mouseAdapter, arg_0));
    }

    private /* synthetic */ void lambda$addMarker$2(2 mouseAdapter, Marker marker) {
        marker.addMouseListener(mouseAdapter);
        this.mapView.addMarker(marker);
    }
}

