/*
 * Decompiled with CFR 0.152.
 */
package com.kpouer.roadwork.ui;

import com.kpouer.roadwork.action.LogsPanelAction;
import com.kpouer.roadwork.action.ReloadAction;
import com.kpouer.roadwork.action.SynchronizeAction;
import com.kpouer.roadwork.configuration.Config;
import com.kpouer.roadwork.event.ExceptionEvent;
import com.kpouer.roadwork.event.OpendataServiceUpdated;
import com.kpouer.roadwork.event.SynchronizationSettingsUpdated;
import com.kpouer.roadwork.event.UserSettingsUpdated;
import com.kpouer.roadwork.service.LocalizationService;
import com.kpouer.roadwork.service.OpendataServiceManager;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.util.Arrays;
import javax.annotation.PostConstruct;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JPanel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationListener;
import org.springframework.lang.NonNull;

@org.springframework.stereotype.Component
public class ToolbarPanel
extends JPanel
implements ApplicationListener<ApplicationEvent> {
    private static final Logger logger = LoggerFactory.getLogger(ToolbarPanel.class);
    private final JButton synchronizeButton;
    private final Config config;
    private final OpendataServiceManager opendataServiceManager;
    private final JButton logsPanelButton;
    private final Color defaultBackground;
    private final JComboBox<Object> opendataServiceComboBox;

    public ToolbarPanel(ApplicationContext applicationContext, Config config, ApplicationEventPublisher applicationEventPublisher, final LocalizationService localizationService, OpendataServiceManager opendataServiceManager) {
        super(new BorderLayout());
        this.config = config;
        this.opendataServiceManager = opendataServiceManager;
        JPanel panel = new JPanel(new FlowLayout(3));
        this.opendataServiceComboBox = new JComboBox();
        this.opendataServiceComboBox.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                Component listCellRendererComponent = super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                String serviceName = String.valueOf(value);
                String key = "opendataService." + value;
                String localizedText = localizationService.getMessage(key);
                if (localizedText != key) {
                    this.setText(localizedText);
                } else if (serviceName.endsWith("Service")) {
                    this.setText(serviceName.substring(0, serviceName.length() - "Service".length()));
                } else {
                    int minusIndex = serviceName.indexOf(45);
                    serviceName = serviceName.substring(minusIndex + 1, serviceName.length() - ".json".length());
                    this.setText(serviceName);
                }
                return listCellRendererComponent;
            }
        });
        this.opendataServiceComboBox.addActionListener(e -> {
            String selectedItem = (String)this.opendataServiceComboBox.getSelectedItem();
            assert (selectedItem != null);
            OpendataServiceUpdated event = new OpendataServiceUpdated(this, config.getOpendataService(), selectedItem);
            config.setOpendataService(selectedItem);
            applicationEventPublisher.publishEvent(event);
        });
        panel.add(this.opendataServiceComboBox);
        this.synchronizeButton = new JButton(applicationContext.getBean(SynchronizeAction.class));
        this.synchronizeButton.setEnabled(config.getUserSettings().isSynchronizationEnabled());
        panel.add(new JButton(applicationContext.getBean(ReloadAction.class)));
        panel.add(this.synchronizeButton);
        JCheckBox hideExpired = new JCheckBox(localizationService.getMessage("toolbarPanel.hideExpired"));
        hideExpired.addActionListener(e -> {
            config.getUserSettings().setHideExpired(hideExpired.isSelected());
            applicationEventPublisher.publishEvent(new UserSettingsUpdated(this));
        });
        panel.add(hideExpired);
        this.logsPanelButton = new JButton(applicationContext.getBean(LogsPanelAction.class));
        this.defaultBackground = this.logsPanelButton.getBackground();
        this.logsPanelButton.addActionListener(e -> this.logsPanelButton.setBackground(this.defaultBackground));
        panel.add(this.logsPanelButton);
        this.add(panel);
    }

    @PostConstruct
    public void init() {
        logger.info("init");
        Object[] serviceNames = this.opendataServiceManager.getServices().toArray(new String[0]);
        Arrays.sort(serviceNames);
        EventQueue.invokeLater(() -> this.lambda$init$3((String[])serviceNames));
    }

    @Override
    public void onApplicationEvent(@NonNull ApplicationEvent event) {
        OpendataServiceUpdated opendataServiceUpdated;
        if (event instanceof SynchronizationSettingsUpdated) {
            this.synchronizeButton.setEnabled(this.config.getUserSettings().isSynchronizationEnabled());
        } else if (event instanceof ExceptionEvent) {
            this.logsPanelButton.setBackground(Color.RED);
        } else if (event instanceof OpendataServiceUpdated && !(opendataServiceUpdated = (OpendataServiceUpdated)event).getNewService().equals(this.opendataServiceComboBox.getSelectedItem())) {
            this.opendataServiceComboBox.setSelectedItem(opendataServiceUpdated.getNewService());
        }
    }

    private /* synthetic */ void lambda$init$3(String[] serviceNames) {
        this.opendataServiceComboBox.setModel(new DefaultComboBoxModel<String>(serviceNames));
        this.opendataServiceComboBox.setSelectedItem(this.config.getOpendataService());
    }
}

