/*
 * Decompiled with CFR 0.152.
 */
package com.kpouer.roadwork.ui.dialog;

import com.kpouer.roadwork.configuration.Config;
import com.kpouer.roadwork.configuration.UserSettings;
import com.kpouer.roadwork.event.SynchronizationSettingsUpdated;
import com.kpouer.roadwork.service.SoftwareModel;
import java.awt.Component;
import java.awt.Container;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import net.miginfocom.swing.MigLayout;
import org.springframework.context.ApplicationEventPublisher;

public class SynchronizationSettingsDialog
extends JDialog {
    public SynchronizationSettingsDialog(SoftwareModel softwareModel, Config config, ApplicationEventPublisher applicationEventPublisher) {
        super(softwareModel.getMainFrame(), "Synchronization settings", true);
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new MigLayout());
        UserSettings userSettings = config.getUserSettings();
        JCheckBox enableSynchronization = new JCheckBox("enable synchronization");
        JTextField urlField = new JTextField(40);
        JTextField teamField = new JTextField(40);
        JTextField loginField = new JTextField(40);
        JPasswordField passwordField = new JPasswordField(40);
        boolean synchronizationEnabled = userSettings.isSynchronizationEnabled();
        if (synchronizationEnabled) {
            enableSynchronization.setSelected(true);
        } else {
            loginField.setEnabled(false);
            passwordField.setEnabled(false);
            urlField.setEnabled(false);
            teamField.setEnabled(false);
        }
        urlField.setText(userSettings.getSynchronizationUrl());
        teamField.setText(userSettings.getSynchronizationTeam());
        loginField.setText(userSettings.getSynchronizationLogin());
        passwordField.setText(userSettings.getSynchronizationPassword());
        enableSynchronization.addActionListener(e -> {
            urlField.setEnabled(enableSynchronization.isSelected());
            teamField.setEnabled(enableSynchronization.isSelected());
            loginField.setEnabled(enableSynchronization.isSelected());
            passwordField.setEnabled(enableSynchronization.isSelected());
        });
        contentPane.add((Component)enableSynchronization, "wrap, span 2");
        contentPane.add(new JLabel("Synchronization server :"));
        contentPane.add((Component)urlField, "wrap");
        contentPane.add(new JLabel("Team :"));
        contentPane.add((Component)teamField, "wrap");
        contentPane.add(new JLabel("Login :"));
        contentPane.add((Component)loginField, "wrap");
        contentPane.add(new JLabel("Password :"));
        contentPane.add((Component)passwordField, "wrap");
        JButton ok = new JButton("ok");
        contentPane.add(ok);
        ok.addActionListener(e -> {
            String synchronizationUrl = urlField.getText().trim();
            String synchronizationTeam = teamField.getText().trim();
            userSettings.setSynchronizationEnabled(enableSynchronization.isSelected());
            userSettings.setSynchronizationUrl(synchronizationUrl);
            userSettings.setSynchronizationTeam(synchronizationTeam);
            userSettings.setSynchronizationLogin(loginField.getText().trim());
            userSettings.setSynchronizationPassword(passwordField.getText().trim());
            applicationEventPublisher.publishEvent(new SynchronizationSettingsUpdated(this));
            this.dispose();
        });
        JButton cancel = new JButton("cancel");
        cancel.addActionListener(e -> this.dispose());
        contentPane.add(cancel);
        this.pack();
    }
}

