/*
 * Decompiled with CFR 0.152.
 */
package com.kpouer.roadwork.ui.logpanel;

import com.kpouer.roadwork.ui.MainPanel;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.springframework.context.annotation.Lazy;
import org.springframework.context.annotation.Scope;

@org.springframework.stereotype.Component
@Lazy
@Scope(value="prototype")
public class LogPanelDialog
extends JDialog {
    public LogPanelDialog(MainPanel parent, List<String> logs) {
        super(parent);
        JList<String> list = new JList<String>(new StringAbstractListModel(logs));
        list.setSelectionMode(1);
        this.add(new JScrollPane(list));
        this.setSize(1024, 768);
        JPanel toolbarPanel = new JPanel(new FlowLayout(3));
        JButton copy = new JButton("Copy");
        toolbarPanel.add(copy);
        copy.addActionListener(e -> {
            StringBuilder builder = new StringBuilder(10000);
            list.getSelectedValuesList().forEach(line -> builder.append((String)line).append('\n'));
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(builder.toString()), null);
        });
        this.getContentPane().add((Component)toolbarPanel, "North");
    }

    private static class StringAbstractListModel
    extends AbstractListModel<String> {
        private final List<String> logs;

        @Override
        public int getSize() {
            return this.logs.size();
        }

        @Override
        public String getElementAt(int index) {
            return this.logs.get(index);
        }

        public StringAbstractListModel(List<String> logs) {
            this.logs = logs;
        }
    }
}

