/*
 * Decompiled with CFR 0.152.
 */
package com.kpouer.roadwork.ui.menu;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.kpouer.roadwork.service.LocalizationService;
import com.kpouer.roadwork.ui.menu.MenuElement;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;

@Service
public class MenuService {
    private static final Logger logger = LoggerFactory.getLogger(MenuService.class);
    private final ApplicationContext applicationContext;
    private final LocalizationService localizationService;

    public JMenuBar loadMenu() throws IOException {
        try (InputStreamReader reader = new InputStreamReader(this.getClass().getResourceAsStream("/com/kpouer/roadwork/ui/menu.json"), StandardCharsets.UTF_8);){
            ObjectMapper objectMapper = new ObjectMapper();
            MenuElement[] menuElement = objectMapper.readValue((Reader)reader, MenuElement[].class);
            JMenuBar menuBar = new JMenuBar();
            for (MenuElement element : menuElement) {
                menuBar.add(this.getComponent(element));
            }
            JMenuBar jMenuBar = menuBar;
            return jMenuBar;
        }
    }

    private JComponent getComponent(MenuElement element) {
        if (element.getChildren() != null) {
            JMenu menu = new JMenu(this.localizationService.getMessage("menu." + element.getName()));
            for (MenuElement child : element.getChildren()) {
                menu.add(this.getComponent(child));
            }
            return menu;
        }
        String actionName = element.getAction();
        if (actionName == null) {
            JMenuItem jMenuItem = new JMenuItem("---");
            jMenuItem.setEnabled(false);
            return jMenuItem;
        }
        try {
            AbstractAction action = this.applicationContext.getBean(actionName, AbstractAction.class);
            return new JMenuItem(action);
        }
        catch (BeansException e) {
            logger.error("Unable to find menu named {}", (Object)actionName);
            JMenuItem jMenuItem = new JMenuItem(actionName);
            jMenuItem.setEnabled(false);
            return jMenuItem;
        }
    }

    public MenuService(ApplicationContext applicationContext, LocalizationService localizationService) {
        this.applicationContext = applicationContext;
        this.localizationService = localizationService;
    }
}

