/*
 * Decompiled with CFR 0.152.
 */
package com.kpouer.roadwork.ui.opendatainfo;

import com.kpouer.mapview.MapView;
import com.kpouer.mapview.marker.Circle;
import com.kpouer.mapview.tile.DefaultTileServer;
import com.kpouer.roadwork.opendata.OpendataService;
import com.kpouer.roadwork.opendata.json.model.Metadata;
import com.kpouer.roadwork.service.LocalizationService;
import com.kpouer.roadwork.service.OpendataServiceManager;
import com.kpouer.roadwork.service.exception.OpenDataException;
import com.kpouer.roadwork.ui.opendatainfo.OpendataInformationPanel;
import java.awt.Color;
import java.awt.Dimension;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;

public class OpendataInformationDialog
extends JDialog {
    private final OpendataServiceManager opendataServiceManager;
    private final MapView mapView;
    private final OpendataInformationPanel opendataInformationPanel;

    public OpendataInformationDialog(JFrame parent, OpendataServiceManager opendataServiceManager, DefaultTileServer tileServer, LocalizationService localizationService) {
        super(parent);
        this.opendataServiceManager = opendataServiceManager;
        this.mapView = new MapView(tileServer);
        JSplitPane splitPane = new JSplitPane(1);
        this.addThirdParty();
        JTree licenceTree = this.buildLicenceTree();
        licenceTree.setPreferredSize(new Dimension(150, 0));
        this.opendataInformationPanel = new OpendataInformationPanel(localizationService);
        this.opendataInformationPanel.setPreferredSize(new Dimension(150, 0));
        licenceTree.addTreeSelectionListener(e -> {
            TreePath path = e.getPath();
            DefaultMutableTreeNode leaf = (DefaultMutableTreeNode)path.getLastPathComponent();
            Object userObject = leaf.getUserObject();
            if (userObject instanceof Metadata) {
                Metadata metadata = (Metadata)userObject;
                this.opendataInformationPanel.setMetadata(metadata);
            }
        });
        splitPane.setLeftComponent(new JScrollPane(licenceTree));
        JSplitPane rightSplit = new JSplitPane(1);
        rightSplit.setLeftComponent(this.opendataInformationPanel);
        rightSplit.setRightComponent(this.mapView);
        splitPane.setRightComponent(rightSplit);
        this.getContentPane().add(splitPane);
        this.mapView.setZoom(3);
        this.setSize(800, 480);
    }

    private void addThirdParty() {
        this.opendataServiceManager.getThirdPartyServices().stream().map(this::getOpendataService).filter(Objects::nonNull).map(OpendataService::getMetadata).map(metadata -> OpendataInformationDialog.buildCircle(metadata, Color.BLUE)).forEach(this.mapView::addMarker);
    }

    private OpendataService getOpendataService(String name) {
        try {
            return this.opendataServiceManager.getOpendataService(name);
        }
        catch (OpenDataException e) {
            return null;
        }
    }

    private JTree buildLicenceTree() {
        List<String> services = this.opendataServiceManager.getDefaultServices();
        DefaultMutableTreeNode root = new DefaultMutableTreeNode();
        HashMap<String, DefaultMutableTreeNode> countryNodes = new HashMap<String, DefaultMutableTreeNode>();
        List<DefaultMutableTreeNode> nodes = services.parallelStream().map(this::getOpendataService).filter(Objects::nonNull).map(OpendataService::getMetadata).map(DefaultMutableTreeNode::new).toList();
        for (DefaultMutableTreeNode node : nodes) {
            Metadata metadata = (Metadata)node.getUserObject();
            this.mapView.addMarker(OpendataInformationDialog.buildCircle(metadata, Color.RED));
            String country = metadata.getCountry();
            DefaultMutableTreeNode countryNode = countryNodes.computeIfAbsent(country, DefaultMutableTreeNode::new);
            countryNode.add(node);
        }
        countryNodes.keySet().stream().sorted().map(countryNodes::get).forEach(root::add);
        return new JTree(root);
    }

    private static Circle buildCircle(Metadata metadata, Color color) {
        return new Circle(metadata.getCenter().getLat(), metadata.getCenter().getLon(), 5, color);
    }
}

