/*
 * Decompiled with CFR 0.152.
 */
package com.kpouer.wkt;

import com.kpouer.wkt.AbstractWKTVisitor;
import com.kpouer.wkt.GeometryCollection;
import com.kpouer.wkt.MultiLineString;
import com.kpouer.wkt.MultiPolygon;
import com.kpouer.wkt.SimpleNode;
import com.kpouer.wkt.shape.LineString;
import com.kpouer.wkt.shape.MultiPoint;
import com.kpouer.wkt.shape.Point;
import com.kpouer.wkt.shape.Polygon;
import com.kpouer.wkt.shape.Shape;
import java.util.ArrayList;
import java.util.List;

public class ShapeVisitor
extends AbstractWKTVisitor {
    @Override
    public Point visit(com.kpouer.wkt.Point point, Object data) {
        return new Point(Double.parseDouble(point.jjtGetFirstToken().image), Double.parseDouble(point.jjtGetLastToken().image));
    }

    @Override
    public LineString visit(com.kpouer.wkt.LineString lineString, Object data) {
        return ShapeVisitor.buildMultiPointShape(lineString, LineString::new);
    }

    @Override
    public Polygon visit(com.kpouer.wkt.Polygon polygon, Object data) {
        return ShapeVisitor.buildMultiPointShape(polygon, Polygon::new);
    }

    @Override
    public com.kpouer.wkt.shape.MultiLineString visit(MultiLineString multiLineString, Object data) {
        int nb = multiLineString.jjtGetNumChildren();
        ArrayList<LineString> lineStrings = new ArrayList<LineString>(nb);
        for (int i = 0; i < nb; ++i) {
            LineString lineString = this.visit((com.kpouer.wkt.LineString)multiLineString.jjtGetChild(i), data);
            lineStrings.add(lineString);
        }
        return new com.kpouer.wkt.shape.MultiLineString((List<LineString>)lineStrings);
    }

    @Override
    public MultiPoint visit(com.kpouer.wkt.MultiPoint multiPoint, Object data) {
        int nb = multiPoint.jjtGetNumChildren();
        ArrayList<Point> list = new ArrayList<Point>(nb);
        for (int i = 0; i < nb; ++i) {
            Point visit = this.visit((com.kpouer.wkt.Point)multiPoint.jjtGetChild(i), data);
            list.add(visit);
        }
        return new MultiPoint(list);
    }

    @Override
    public com.kpouer.wkt.shape.MultiPolygon visit(MultiPolygon multiPolygon, Object data) {
        int nb = multiPolygon.jjtGetNumChildren();
        ArrayList<Polygon> polygons = new ArrayList<Polygon>(nb);
        for (int i = 0; i < nb; ++i) {
            Polygon polygon = this.visit((com.kpouer.wkt.Polygon)multiPolygon.jjtGetChild(i), data);
            polygons.add(polygon);
        }
        return new com.kpouer.wkt.shape.MultiPolygon((List<Polygon>)polygons);
    }

    @Override
    public com.kpouer.wkt.shape.GeometryCollection visit(GeometryCollection geometryCollection, Object data) {
        int nb = geometryCollection.jjtGetNumChildren();
        ArrayList<Shape> polygons = new ArrayList<Shape>(nb);
        for (int i = 0; i < nb; ++i) {
            Shape visit = (Shape)this.visit((SimpleNode)geometryCollection.jjtGetChild(i), data);
            polygons.add(visit);
        }
        return new com.kpouer.wkt.shape.GeometryCollection((List<Shape>)polygons);
    }

    private static <E> E buildMultiPointShape(SimpleNode node, MultPointShapeBuilder<E> multPointShapeBuilder) {
        int npoints = node.jjtGetNumChildren();
        double[] xpoints = new double[npoints];
        double[] ypoints = new double[npoints];
        for (int i = 0; i < npoints; ++i) {
            com.kpouer.wkt.Point point = (com.kpouer.wkt.Point)node.jjtGetChild(i);
            xpoints[i] = Double.parseDouble(point.jjtGetFirstToken().image);
            ypoints[i] = Double.parseDouble(point.jjtGetLastToken().image);
        }
        return multPointShapeBuilder.build(xpoints, ypoints);
    }

    @FunctionalInterface
    private static interface MultPointShapeBuilder<E> {
        public E build(double[] var1, double[] var2);
    }
}

