/*
 * Decompiled with CFR 0.152.
 */
package com.kpouer.wkt.shape;

import com.kpouer.wkt.shape.AbstractShape;
import com.kpouer.wkt.shape.Point;
import java.awt.geom.Rectangle2D;
import java.util.Arrays;

public abstract class AbstractMultiPointShape
extends AbstractShape {
    private static final int MINSIZE = 4;
    private double[] xpoints;
    private double[] ypoints;
    private int npoints;
    private boolean closed;

    protected AbstractMultiPointShape(double[] xpoints, double[] ypoints, boolean closed) {
        this.xpoints = xpoints;
        this.ypoints = ypoints;
        this.closed = closed;
        this.npoints = xpoints.length;
    }

    protected AbstractMultiPointShape() {
        this.xpoints = new double[4];
        this.ypoints = new double[4];
    }

    @Override
    protected Point computeBarycenter() {
        int i;
        if (this.npoints == 0) {
            return new Point();
        }
        if (this.closed && this.npoints == 1) {
            return new Point();
        }
        double x = 0.0;
        double y = 0.0;
        int n = i = this.closed ? 1 : 0;
        while (i < this.xpoints.length) {
            x += this.xpoints[i];
            y += this.ypoints[i];
            ++i;
        }
        int nbPoints = this.closed ? this.npoints - 1 : this.npoints;
        return new Point(x / (double)nbPoints, y / (double)nbPoints);
    }

    @Override
    public Rectangle2D.Double getBounds2D() {
        double x1 = this.xpoints[0];
        double y1 = this.ypoints[0];
        double x2 = this.xpoints[0];
        double y2 = this.ypoints[0];
        for (int i = 1; i < this.npoints; ++i) {
            double x = this.xpoints[i];
            double y = this.ypoints[i];
            x1 = Math.min(x1, x);
            y1 = Math.min(y1, y);
            x2 = Math.max(x2, x);
            y2 = Math.max(y2, y);
        }
        return new Rectangle2D.Double(x1, y1, x2 - x1, y2 - y1);
    }

    public double[] getXpoints() {
        return this.xpoints;
    }

    public double[] getYpoints() {
        return this.ypoints;
    }

    public int getNpoints() {
        return this.npoints;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AbstractMultiPointShape)) {
            return false;
        }
        AbstractMultiPointShape other = (AbstractMultiPointShape)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getNpoints() != other.getNpoints()) {
            return false;
        }
        if (this.isClosed() != other.isClosed()) {
            return false;
        }
        if (!Arrays.equals(this.getXpoints(), other.getXpoints())) {
            return false;
        }
        return Arrays.equals(this.getYpoints(), other.getYpoints());
    }

    protected boolean canEqual(Object other) {
        return other instanceof AbstractMultiPointShape;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getNpoints();
        result = result * 59 + (this.isClosed() ? 79 : 97);
        result = result * 59 + Arrays.hashCode(this.getXpoints());
        result = result * 59 + Arrays.hashCode(this.getYpoints());
        return result;
    }
}

