/*
 * Decompiled with CFR 0.152.
 */
package com.kpouer.wkt.shape;

import com.kpouer.wkt.shape.AbstractShape;
import com.kpouer.wkt.shape.Point;
import com.kpouer.wkt.shape.Shape;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractMultiShape<E extends Shape>
extends AbstractShape {
    protected final List<E> shapes;

    protected AbstractMultiShape() {
        this.shapes = new ArrayList();
    }

    protected void addShape(E shape) {
        this.shapes.add(shape);
        this.barycenter = null;
    }

    @Override
    protected Point computeBarycenter() {
        Point[] barycenters = this.getBarycenters();
        return AbstractMultiShape.computeBarycenterFromPoints(barycenters);
    }

    private Point[] getBarycenters() {
        Point[] barycenters = new Point[this.shapes.size()];
        for (int i = 0; i < barycenters.length; ++i) {
            barycenters[i] = ((Shape)this.shapes.get(i)).getBarycenter();
        }
        return barycenters;
    }

    private static Point computeBarycenterFromPoints(Point[] barycenters) {
        double x = 0.0;
        double y = 0.0;
        for (Point barycenter : barycenters) {
            x += barycenter.getX();
            y += barycenter.getY();
        }
        return new Point(x /= (double)barycenters.length, y /= (double)barycenters.length);
    }

    @Override
    public Rectangle2D.Double getBounds2D() {
        if (this.shapes.isEmpty()) {
            return new Rectangle2D.Double();
        }
        Rectangle2D.Double bounds = ((Shape)this.shapes.get(0)).getBounds2D();
        double x1 = bounds.getMinX();
        double y1 = bounds.getMinY();
        double x2 = bounds.getMaxY();
        double y2 = bounds.getMaxY();
        int size = this.shapes.size();
        for (int i = 1; i < size; ++i) {
            Rectangle2D.Double otherBounds = ((Shape)this.shapes.get(i)).getBounds2D();
            x1 = Math.min(x1, otherBounds.getMinX());
            y1 = Math.min(y1, otherBounds.getMinY());
            x2 = Math.max(x2, otherBounds.getMaxX());
            y2 = Math.max(y2, otherBounds.getMaxY());
        }
        return new Rectangle2D.Double(x1, y1, x2 - x1, y2 - y1);
    }

    public List<E> getShapes() {
        return this.shapes;
    }

    public AbstractMultiShape(List<E> shapes) {
        this.shapes = shapes;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AbstractMultiShape)) {
            return false;
        }
        AbstractMultiShape other = (AbstractMultiShape)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<E> this$shapes = this.getShapes();
        List<E> other$shapes = other.getShapes();
        return !(this$shapes == null ? other$shapes != null : !((Object)this$shapes).equals(other$shapes));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AbstractMultiShape;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<E> $shapes = this.getShapes();
        result = result * 59 + ($shapes == null ? 43 : ((Object)$shapes).hashCode());
        return result;
    }
}

