/*
 * Decompiled with CFR 0.152.
 */
package com.kpouer.wkt.shape;

import com.kpouer.wkt.shape.AbstractShape;
import com.kpouer.wkt.shape.Point;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;

public class MultiPoint
extends AbstractShape {
    private final List<Point> points;

    public MultiPoint(List<Point> points) {
        this.points = points;
    }

    public MultiPoint() {
        this.points = new ArrayList<Point>();
    }

    @Override
    protected Point computeBarycenter() {
        double x = this.points.get(0).getX();
        double y = this.points.get(0).getY();
        int size = this.points.size();
        for (int i = 1; i < size; ++i) {
            Point point = this.points.get(i);
            x += point.getX();
            y += point.getY();
        }
        return new Point(x / (double)size, y / (double)size);
    }

    @Override
    public Rectangle2D.Double getBounds2D() {
        double x1 = this.points.get(0).getX();
        double y1 = this.points.get(0).getY();
        double x2 = x1;
        double y2 = y1;
        int size = this.points.size();
        for (int i = 1; i < size; ++i) {
            Point point = this.points.get(i);
            x1 = Math.min(x1, point.getX());
            y1 = Math.min(y1, point.getY());
            x2 = Math.max(x2, point.getX());
            y2 = Math.max(y2, point.getY());
        }
        return new Rectangle2D.Double(x1, y1, x2 - x1, y2 - y1);
    }

    public List<Point> getPoints() {
        return this.points;
    }
}

