/*
 * Decompiled with CFR 0.152.
 */
package com.kpouer.mapview.marker;

import com.kpouer.mapview.marker.Marker;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;

public class Circle
extends Marker {
    private int radius;
    private Color color;

    public Circle(double latitude, double longitude, int radius, Color color) {
        super(latitude, longitude);
        this.radius = radius;
        this.color = color;
    }

    public int getRadius() {
        return this.radius;
    }

    public void setRadius(int radius) {
        this.radius = radius;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    @Override
    public void paint(Graphics g) {
        g.setColor(this.color);
        g.fillOval(this.x - this.radius, this.y - this.radius, 2 * this.radius, 2 * this.radius);
    }

    @Override
    public boolean contains(Point point) {
        return point.getX() >= (double)(this.x - this.radius) && point.getX() < (double)(this.x + this.radius) && point.getY() >= (double)(this.y - this.radius) && point.getY() < (double)(this.y + this.radius);
    }

    public String toString() {
        return "Circle{longitude=" + this.longitude + ", latitude=" + this.latitude + ", radius=" + this.radius + ", x=" + this.x + ", y=" + this.y + "}";
    }
}

