/*
 * Decompiled with CFR 0.152.
 */
package com.kpouer.mapview.tile;

public class Tile {
    private final int x;
    private final int y;
    private final int zoom;

    public Tile(int x, int y, int zoom) {
        this.x = x;
        this.y = y;
        this.zoom = zoom;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getZoom() {
        return this.zoom;
    }

    public String getKey() {
        return this.zoom + "_" + this.x + "_" + this.y;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Tile tile = (Tile)o;
        if (this.x != tile.x) {
            return false;
        }
        if (this.y != tile.y) {
            return false;
        }
        return this.zoom == tile.zoom;
    }

    public int hashCode() {
        int result = this.x;
        result = 31 * result + this.y;
        result = 31 * result + this.zoom;
        return result;
    }

    public String toString() {
        return "Tile{x=" + this.x + ", y=" + this.y + ", zoom=" + this.zoom + "}";
    }
}

