/*
 * Decompiled with CFR 0.152.
 */
package com.kpouer.mapview.tile;

import com.kpouer.mapview.MapPoint;

public class TilesTools {
    private static final double minLatitude = -85.05112878;
    private static final double maxLatitude = 85.05112878;
    private static final double minLongitude = -180.0;
    private static final double maxLongitude = 180.0;
    private final int tileSize;

    public TilesTools(int tileSize) {
        this.tileSize = tileSize;
    }

    public double position2longitude(int x, int zoom) {
        double maxX = this.tileSize * (1 << zoom);
        return (double)x / maxX * 360.0 - 180.0;
    }

    public double position2latitude(int y, int zoom) {
        double maxY = this.tileSize * (1 << zoom);
        return Math.toDegrees(StrictMath.atan(StrictMath.sinh(Math.PI - Math.PI * 2 * (double)y / maxY)));
    }

    public int longitudeToPoint(double longitude, int zoom) {
        double maxX = this.tileSize * (1 << zoom);
        return (int)Math.floor((longitude + 180.0) / 360.0 * maxX);
    }

    public int latitudeToPoint(double latitude, int zoom) {
        double maxY = this.tileSize * (1 << zoom);
        return (int)Math.floor((1.0 - StrictMath.log(StrictMath.tan(Math.toRadians(latitude)) + 1.0 / StrictMath.cos(Math.toRadians(latitude))) / Math.PI) / 2.0 * maxY);
    }

    public int clip(int value, int min, int max) {
        return Math.min(Math.max(value, min), max);
    }

    public double clipLatitude(double latitude) {
        return this.clip(latitude, -85.05112878, 85.05112878);
    }

    public double clipLongitude(double longitude) {
        return this.clip(longitude, -180.0, 180.0);
    }

    private double clip(double value, double min, double max) {
        return Math.min(Math.max(value, min), max);
    }

    public int zoom(int pos, int zoom, int newZoom) {
        if (zoom == newZoom) {
            return pos;
        }
        int i = newZoom - zoom;
        if (i > 0) {
            return pos << i;
        }
        return pos >> -i;
    }

    public MapPoint zoom(MapPoint mapPoint, int zoom, int newZoom) {
        return new MapPoint(this.zoom(mapPoint.getX(), zoom, newZoom), this.zoom(mapPoint.getY(), zoom, newZoom), newZoom);
    }
}

