/*
 * Decompiled with CFR 0.152.
 */
package com.kpouer.roadwork.action;

import com.kpouer.mapview.tile.DefaultTileServer;
import com.kpouer.roadwork.service.LocalizationService;
import com.kpouer.roadwork.service.OpendataServiceManager;
import com.kpouer.roadwork.service.SoftwareModel;
import com.kpouer.roadwork.ui.opendatainfo.OpendataInformationDialog;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.lang.Nullable;
import org.springframework.stereotype.Component;

@Component
public class OpendataInformationAction
extends AbstractAction {
    private final SoftwareModel softwareModel;
    private final LocalizationService localizationService;
    private final OpendataServiceManager opendataServiceManager;
    private final DefaultTileServer tileServer;

    public OpendataInformationAction(SoftwareModel softwareModel, LocalizationService localizationService, OpendataServiceManager opendataServiceManager, @Qualifier(value="WazeINTLTileServer") DefaultTileServer tileServer) {
        super(localizationService.getMessage("action.opendataInformationAction"));
        this.softwareModel = softwareModel;
        this.localizationService = localizationService;
        this.opendataServiceManager = opendataServiceManager;
        this.tileServer = tileServer;
    }

    @Override
    public void actionPerformed(@Nullable ActionEvent e) {
        OpendataInformationDialog dialog = new OpendataInformationDialog(this.softwareModel.getMainFrame(), this.opendataServiceManager, this.tileServer, this.localizationService);
        dialog.setLocationRelativeTo(this.softwareModel.getMainFrame());
        dialog.setVisible(true);
    }
}

