/*
 * Decompiled with CFR 0.152.
 */
package com.kpouer.roadwork.configuration;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.PatternLayout;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.kpouer.mapview.MapView;
import com.kpouer.mapview.tile.DefaultTileServer;
import com.kpouer.mapview.tile.cache.ImageCacheImpl;
import com.kpouer.roadwork.configuration.UserSettings;
import com.kpouer.roadwork.log.LoopListAppender;
import com.kpouer.roadwork.service.SoftwareModel;
import java.awt.Rectangle;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import javax.annotation.PreDestroy;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;
import org.springframework.util.StringUtils;

@Configuration
public class Config {
    private static final Logger log = LoggerFactory.getLogger(Config.class);
    public static final String DEFAULT_OPENDATA_SERVICE = "France-Paris.json";
    private List<String> logs;
    private int tilesSize = 256;
    private int minZoom = 1;
    private int maxZoom = 18;
    private int threadCount = 2;
    private String datePattern = "yyyy-MM-dd";
    private String dataPath;
    private String legacyDataPath = "data";
    private UserSettings userSettings;
    private final SoftwareModel softwareModel;
    private int connectTimeout = 1000;
    private int connectionRequestTimeout = 1000;
    private int readTimeout = 300000;

    public Config(SoftwareModel softwareModel, ApplicationEventPublisher applicationEventPublisher) {
        this.softwareModel = softwareModel;
        this.configureLogger(applicationEventPublisher);
        log.info("Config start");
        String userHome = System.getProperty("user.home");
        if (userHome == null) {
            this.dataPath = "data";
        } else {
            this.dataPath = userHome + "/.roadwork";
            this.migrateIfNecessary();
        }
        Path userSettingsPath = this.getUserSettingsPath();
        if (Files.exists(userSettingsPath, new LinkOption[0])) {
            ObjectMapper objectMapper = new ObjectMapper();
            try {
                this.userSettings = objectMapper.readValue(userSettingsPath.toFile(), UserSettings.class);
            }
            catch (IOException e) {
                log.error("Error trying to read user settings");
                this.userSettings = new UserSettings();
            }
        } else {
            this.userSettings = new UserSettings();
        }
    }

    private void configureLogger(ApplicationEventPublisher applicationEventPublisher) {
        PatternLayout layout = new PatternLayout();
        layout.setContext((LoggerContext)LoggerFactory.getILoggerFactory());
        layout.setPattern("%date %level [%thread] %logger{10} [%file:%line] %msg");
        layout.start();
        LoopListAppender loopListAppender = new LoopListAppender(layout, applicationEventPublisher);
        this.logs = loopListAppender.getList();
        Logger rootLogger = LoggerFactory.getLogger("ROOT");
        loopListAppender.start();
        ((ch.qos.logback.classic.Logger)rootLogger).addAppender(loopListAppender);
    }

    private void migrateIfNecessary() {
        Path oldData;
        if (!Files.exists(Path.of(this.dataPath, new String[0]), new LinkOption[0]) && Files.exists(oldData = Path.of("data", new String[0]), new LinkOption[0])) {
            log.info("migrate data");
            try {
                Files.move(oldData, Path.of(this.dataPath, new String[0]), new CopyOption[0]);
            }
            catch (IOException e) {
                log.error("Unable to migrate data", e);
            }
        }
    }

    @NotNull
    private Path getUserSettingsPath() {
        return Path.of(this.dataPath, "userSettings.json");
    }

    @PreDestroy
    public void stop() {
        log.info("stop");
        try {
            Rectangle bounds = this.softwareModel.getMainFrame().getBounds();
            this.userSettings.setFrameX(bounds.x);
            this.userSettings.setFrameY(bounds.y);
            this.userSettings.setFrameWidth(bounds.width);
            this.userSettings.setFrameHeight(bounds.height);
            ObjectMapper objectMapper = new ObjectMapper();
            Path userSettingsPath = this.getUserSettingsPath();
            if (!Files.exists(userSettingsPath.getParent(), new LinkOption[0])) {
                Files.createDirectory(userSettingsPath.getParent(), new FileAttribute[0]);
            }
            objectMapper.writeValue(userSettingsPath.toFile(), (Object)this.userSettings);
        }
        catch (IOException e) {
            log.error("Error while saving settings", e);
        }
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public int getConnectionRequestTimeout() {
        return this.connectionRequestTimeout;
    }

    public void setConnectionRequestTimeout(int connectionRequestTimeout) {
        this.connectionRequestTimeout = connectionRequestTimeout;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public void setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
    }

    public int getTilesSize() {
        return this.tilesSize;
    }

    public void setTilesSize(int tilesSize) {
        this.tilesSize = tilesSize;
    }

    public int getMinZoom() {
        return this.minZoom;
    }

    public void setMinZoom(int minZoom) {
        this.minZoom = minZoom;
    }

    public int getMaxZoom() {
        return this.maxZoom;
    }

    public void setMaxZoom(int maxZoom) {
        this.maxZoom = maxZoom;
    }

    public int getThreadCount() {
        return this.threadCount;
    }

    public void setThreadCount(int threadCount) {
        this.threadCount = threadCount;
    }

    public String getDatePattern() {
        return this.datePattern;
    }

    public void setDatePattern(String datePattern) {
        this.datePattern = datePattern;
    }

    public String getOpendataService() {
        if (StringUtils.hasLength(this.userSettings.getOpendataService())) {
            return this.userSettings.getOpendataService();
        }
        return DEFAULT_OPENDATA_SERVICE;
    }

    public void setOpendataService(String opendataService) {
        this.userSettings.setOpendataService(opendataService);
    }

    public String getDataPath() {
        return this.dataPath;
    }

    public void setDataPath(String dataPath) {
        this.dataPath = dataPath;
    }

    public UserSettings getUserSettings() {
        return this.userSettings;
    }

    @Bean(value={"mapview"})
    public MapView getMapView(@Qualifier(value="WazeINTLTileServer") DefaultTileServer tileServer) {
        return new MapView(tileServer);
    }

    @Bean(value={"OsmTileServer"})
    @Lazy
    public DefaultTileServer getOsmTileServer() {
        try {
            return new DefaultTileServer(this.tilesSize, this.minZoom, this.maxZoom, this.threadCount, new ImageCacheImpl("OSM", Path.of(this.dataPath, "cache").toString(), 1000), "https://a.tile.openstreetmap.org/${z}/${x}/${y}.png", "https://b.tile.openstreetmap.org/${z}/${x}/${y}.png", "https://c.tile.openstreetmap.org/${z}/${x}/${y}.png");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Bean(value={"WazeINTLTileServer"})
    @Lazy
    public DefaultTileServer getWazeINTLTileServer() {
        try {
            return new DefaultTileServer(this.tilesSize, this.minZoom, this.maxZoom, this.threadCount, new ImageCacheImpl("Waze", Path.of(this.dataPath, "cache").toString(), 1000), "https://worldtiles1.waze.com/tiles/${z}/${x}/${y}.png", "https://worldtiles2.waze.com/tiles/${z}/${x}/${y}.png", "https://worldtiles3.waze.com/tiles/${z}/${x}/${y}.png");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Bean(value={"WazeNATileServer"})
    @Lazy
    public DefaultTileServer getWazeNATileServer() {
        try {
            return new DefaultTileServer(this.tilesSize, this.minZoom, this.maxZoom, this.threadCount, new ImageCacheImpl("WazeNA", Path.of(this.dataPath, "cache").toString(), 1000), "https://livemap-tiles1.waze.com/tiles/${z}/${x}/${y}.png");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Bean(value={"WazeILTileServer"})
    @Lazy
    public DefaultTileServer getWazeILTileServer() {
        try {
            return new DefaultTileServer(this.tilesSize, this.minZoom, this.maxZoom, this.threadCount, new ImageCacheImpl("WazeIL", Path.of(this.dataPath, "cache").toString(), 1000), "https://il-livemap-tiles1.waze.com/tiles/${z}/${x}/${y}.png");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Bean
    public List<String> logs() {
        return this.logs;
    }
}

