/*
 * Decompiled with CFR 0.152.
 */
package com.kpouer.roadwork.log;

import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.AppenderBase;
import ch.qos.logback.core.Layout;
import com.kpouer.roadwork.event.ExceptionEvent;
import com.kpouer.roadwork.log.LoopList;
import java.util.Arrays;
import java.util.List;
import org.springframework.context.ApplicationEventPublisher;

public class LoopListAppender
extends AppenderBase<ILoggingEvent> {
    private final ApplicationEventPublisher applicationEventPublisher;
    private final List<String> list;
    private final Layout<ILoggingEvent> layout;

    public LoopListAppender(Layout<ILoggingEvent> layout, ApplicationEventPublisher applicationEventPublisher) {
        this.layout = layout;
        this.applicationEventPublisher = applicationEventPublisher;
        this.list = new LoopList<String>(1000);
    }

    @Override
    protected void append(ILoggingEvent eventObject) {
        String res = this.layout.doLayout(eventObject);
        String[] tokens = res.split("\n");
        this.list.addAll(Arrays.asList(tokens));
        if (eventObject.getThrowableProxy() != null) {
            this.applicationEventPublisher.publishEvent(new ExceptionEvent(eventObject));
        }
    }

    public List<String> getList() {
        return this.list;
    }
}

