/*
 * Decompiled with CFR 0.152.
 */
package com.kpouer.roadwork.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.kpouer.mapview.marker.Circle;
import com.kpouer.roadwork.model.sync.Status;
import com.kpouer.roadwork.model.sync.SyncData;
import java.awt.Color;

public class Roadwork {
    private String id;
    private double latitude;
    private double longitude;
    private long start;
    private long end;
    private String road;
    private String locationDetails;
    private String impactCirculationDetail;
    private String description;
    @JsonIgnore
    private Circle marker;
    private SyncData syncData;
    private String url;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public double getLatitude() {
        return this.latitude;
    }

    public void setLatitude(double latitude) {
        this.latitude = latitude;
    }

    public double getLongitude() {
        return this.longitude;
    }

    public void setLongitude(double longitude) {
        this.longitude = longitude;
    }

    public long getStart() {
        return this.start;
    }

    public void setStart(long start) {
        this.start = start;
    }

    public long getEnd() {
        return this.end;
    }

    public void setEnd(long end) {
        this.end = end;
    }

    public String getRoad() {
        return this.road;
    }

    public void setRoad(String road) {
        this.road = road;
    }

    public String getLocationDetails() {
        return this.locationDetails;
    }

    public void setLocationDetails(String locationDetails) {
        this.locationDetails = locationDetails;
    }

    public String getImpactCirculationDetail() {
        return this.impactCirculationDetail;
    }

    public void setImpactCirculationDetail(String impactCirculationDetail) {
        this.impactCirculationDetail = impactCirculationDetail;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void updateStatus(Status status) {
        this.syncData.updateStatus(status);
        this.updateMarker();
    }

    public void updateMarker() {
        if (this.marker != null) {
            this.marker.setColor(this.getColor());
        }
    }

    public Circle getMarker() {
        if (this.marker == null) {
            this.marker = new Circle(this.latitude, this.longitude, 5, this.getColor());
        }
        return this.marker;
    }

    private Color getColor() {
        switch (this.syncData.getStatus()) {
            case New: {
                return Color.RED;
            }
            case Treated: {
                return Color.GREEN;
            }
            case Ignored: {
                return Color.YELLOW;
            }
            case Later: {
                return Color.BLUE;
            }
            case Finished: {
                return Color.GRAY;
            }
        }
        throw new RuntimeException("Unexpected status " + this.start);
    }

    public boolean isExpired() {
        return this.end < System.currentTimeMillis();
    }

    public SyncData getSyncData() {
        return this.syncData;
    }

    public void setSyncData(SyncData syncData) {
        this.syncData = syncData;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getUrl() {
        return this.url;
    }
}

