/*
 * Decompiled with CFR 0.152.
 */
package com.kpouer.roadwork.model;

import com.kpouer.roadwork.model.Roadwork;
import com.kpouer.roadwork.model.sync.SyncData;

public final class RoadworkBuilder {
    private String id;
    private double latitude;
    private double longitude;
    private long start;
    private long end;
    private String road;
    private String locationDetails;
    private String impactCirculationDetail;
    private String description;
    private SyncData syncData = new SyncData();
    private String url;

    private RoadworkBuilder() {
    }

    public static RoadworkBuilder aRoadwork() {
        return new RoadworkBuilder();
    }

    public RoadworkBuilder withId(String id) {
        this.id = id;
        return this;
    }

    public RoadworkBuilder withLatitude(double latitude) {
        this.latitude = latitude;
        return this;
    }

    public RoadworkBuilder withLongitude(double longitude) {
        this.longitude = longitude;
        return this;
    }

    public RoadworkBuilder withStart(long start) {
        this.start = start;
        return this;
    }

    public RoadworkBuilder withEnd(long end) {
        this.end = end;
        return this;
    }

    public RoadworkBuilder withRoad(String road) {
        this.road = road;
        return this;
    }

    public RoadworkBuilder withLocationDetails(String locationDetails) {
        this.locationDetails = locationDetails;
        return this;
    }

    public RoadworkBuilder withImpactCirculationDetail(String impactCirculationDetail) {
        this.impactCirculationDetail = impactCirculationDetail;
        return this;
    }

    public RoadworkBuilder withDescription(String description) {
        this.description = description;
        return this;
    }

    public RoadworkBuilder withSyncData(SyncData syncData) {
        this.syncData = syncData;
        return this;
    }

    public RoadworkBuilder withUrl(String url) {
        this.url = url;
        return this;
    }

    public Roadwork build() {
        Roadwork roadwork = new Roadwork();
        roadwork.setId(this.id);
        roadwork.setLatitude(this.latitude);
        roadwork.setLongitude(this.longitude);
        roadwork.setStart(this.start);
        roadwork.setEnd(this.end);
        roadwork.setRoad(this.road);
        roadwork.setLocationDetails(this.locationDetails);
        roadwork.setImpactCirculationDetail(this.impactCirculationDetail);
        roadwork.setDescription(this.description);
        roadwork.setSyncData(this.syncData);
        roadwork.setUrl(this.url);
        return roadwork;
    }
}

