/*
 * Decompiled with CFR 0.152.
 */
package com.kpouer.roadwork.model;

import com.kpouer.roadwork.model.Roadwork;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class RoadworkData
implements Iterable<Roadwork> {
    private String source;
    private Map<String, Roadwork> roadworks;
    private long created;

    public RoadworkData() {
    }

    public RoadworkData(String source, Collection<Roadwork> roadworks) {
        this.source = source;
        this.roadworks = new HashMap<String, Roadwork>(roadworks.size());
        roadworks.forEach(roadwork -> this.roadworks.put(roadwork.getId(), (Roadwork)roadwork));
        this.created = System.currentTimeMillis();
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    @Override
    @NotNull
    public Iterator<Roadwork> iterator() {
        return this.roadworks.values().iterator();
    }

    public Map<String, Roadwork> getRoadworks() {
        return this.roadworks;
    }

    public void setRoadworks(Map<String, Roadwork> roadworks) {
        this.roadworks = roadworks;
    }

    public long getCreated() {
        return this.created;
    }

    public void setCreated(long created) {
        this.created = created;
    }

    public Roadwork getRoadwork(String id) {
        return this.roadworks.get(id);
    }
}

