/*
 * Decompiled with CFR 0.152.
 */
package com.kpouer.roadwork.model.v1;

import com.kpouer.roadwork.model.Roadwork;
import com.kpouer.roadwork.model.RoadworkData;
import com.kpouer.roadwork.model.v1.RoadworkV1;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class RoadworkDataV1
implements Iterable<RoadworkV1> {
    private String source;
    private Map<String, RoadworkV1> roadworks;
    private long created;

    public RoadworkDataV1() {
    }

    public RoadworkDataV1(String source, Collection<RoadworkV1> roadworks) {
        this.source = source;
        this.roadworks = new HashMap<String, RoadworkV1>(roadworks.size());
        roadworks.forEach(roadwork -> this.roadworks.put(roadwork.getId(), (RoadworkV1)roadwork));
        this.created = System.currentTimeMillis();
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    @Override
    @NotNull
    public Iterator<RoadworkV1> iterator() {
        return this.roadworks.values().iterator();
    }

    public Map<String, RoadworkV1> getRoadworks() {
        return this.roadworks;
    }

    public void setRoadworks(Map<String, RoadworkV1> roadworks) {
        this.roadworks = roadworks;
    }

    public long getCreated() {
        return this.created;
    }

    public void setCreated(long created) {
        this.created = created;
    }

    public RoadworkV1 getRoadwork(String id) {
        return this.roadworks.get(id);
    }

    public RoadworkData toRoadWork() {
        RoadworkData roadworkData = new RoadworkData();
        HashMap<String, Roadwork> roadworks = new HashMap<String, Roadwork>();
        roadworkData.setRoadworks(roadworks);
        roadworkData.setSource(this.source);
        roadworkData.setCreated(this.created);
        for (Map.Entry<String, RoadworkV1> entry : this.roadworks.entrySet()) {
            String key = entry.getKey();
            RoadworkV1 roadworkV1 = entry.getValue();
            Roadwork roadwork = roadworkV1.toRoadwork();
            roadworks.put(key, roadwork);
        }
        return roadworkData;
    }
}

