/*
 * Decompiled with CFR 0.152.
 */
package com.kpouer.roadwork.opendata.json;

import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import com.kpouer.roadwork.model.DateRange;
import com.kpouer.roadwork.model.Roadwork;
import com.kpouer.roadwork.model.RoadworkBuilder;
import com.kpouer.roadwork.model.RoadworkData;
import com.kpouer.roadwork.opendata.OpendataService;
import com.kpouer.roadwork.opendata.json.model.DateParser;
import com.kpouer.roadwork.opendata.json.model.DateResult;
import com.kpouer.roadwork.opendata.json.model.Metadata;
import com.kpouer.roadwork.opendata.json.model.ServiceDescriptor;
import com.kpouer.roadwork.service.HttpService;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.client.RestClientException;

public class DefaultJsonService
implements OpendataService {
    private static final Logger log = LoggerFactory.getLogger(DefaultJsonService.class);
    private final String serviceName;
    private final HttpService httpService;
    private final ServiceDescriptor serviceDescriptor;

    public DefaultJsonService(String serviceName, HttpService httpService, ServiceDescriptor serviceDescriptor) {
        this.serviceName = serviceName;
        this.httpService = httpService;
        this.serviceDescriptor = serviceDescriptor;
    }

    @Override
    public Metadata getMetadata() {
        return this.serviceDescriptor.getMetadata();
    }

    @Override
    public Optional<RoadworkData> getData() throws RestClientException {
        String url = this.buildUrl();
        log.info("getData {}", (Object)url);
        String json = this.httpService.getUrl(url);
        Object document = Configuration.defaultConfiguration().jsonProvider().parse(json);
        List roadworkArray = (List)JsonPath.read(document, this.serviceDescriptor.getRoadworkArray(), new Predicate[0]);
        List<Roadwork> roadworks = roadworkArray.parallelStream().map(node -> DefaultJsonService.buildRoadwork(this.serviceDescriptor, node)).filter(DefaultJsonService::isValid).toList();
        return Optional.of(new RoadworkData(this.serviceName, roadworks));
    }

    private String buildUrl() {
        Metadata metadata = this.serviceDescriptor.getMetadata();
        Map<String, String> urlParams = metadata.getUrlParams();
        Object url = metadata.getUrl();
        if (urlParams == null) {
            return url;
        }
        String queryString = urlParams.entrySet().stream().map(entry -> (String)entry.getKey() + "=" + URLEncoder.encode((String)entry.getValue(), StandardCharsets.UTF_8)).collect(Collectors.joining("&"));
        url = (String)url + (((String)url).indexOf(63) != -1 ? "&" + queryString : "?" + queryString);
        return url;
    }

    public static boolean isValid(Roadwork roadwork) {
        if (roadwork.getLongitude() == 0.0 && roadwork.getLatitude() == 0.0) {
            log.warn("{} is invalid because it has no location", (Object)roadwork);
            return false;
        }
        return true;
    }

    private static Optional<DateResult> parseDate(Object node, DateParser dateParser, ServiceDescriptor serviceDescriptor) throws ParseException {
        if (dateParser == null) {
            log.debug("Cannot parse date as dateParse is null");
            return Optional.empty();
        }
        Calendar calendar = Calendar.getInstance();
        int currentYear = calendar.get(1);
        String value = DefaultJsonService.getPath(node, dateParser.getPath());
        if (value == null) {
            return Optional.empty();
        }
        DateResult result = dateParser.parse(value, serviceDescriptor.getMetadata().getLocale());
        if (result.getParser().isResetHour()) {
            result.setDate(DefaultJsonService.fixTime(calendar, result.getDate()));
        }
        if (result.getParser().isAddYear()) {
            result.setDate(DefaultJsonService.addYear(calendar, currentYear, result.getDate()));
        }
        return Optional.of(result);
    }

    private static DateRange getDateRange(Object node, ServiceDescriptor serviceDescriptor) throws ParseException {
        long endDate;
        long startTime;
        Calendar calendar = Calendar.getInstance();
        int currentYear = calendar.get(1);
        try {
            Optional<DateResult> start = DefaultJsonService.parseDate(node, serviceDescriptor.getFrom(), serviceDescriptor);
            startTime = start.map(DateResult::getDate).orElse(0L);
        }
        catch (Exception e) {
            log.error("Error parsing start date", e);
            startTime = 0L;
        }
        try {
            Optional<DateResult> endOptional = DefaultJsonService.parseDate(node, serviceDescriptor.getTo(), serviceDescriptor);
            if (endOptional.isPresent()) {
                DateResult end = endOptional.get();
                endDate = end.getDate();
                if (end.getParser().isAddYear() && startTime > (endDate = DefaultJsonService.addYear(calendar, currentYear, endDate))) {
                    endDate = DefaultJsonService.addYear(calendar, currentYear + 1, endDate);
                }
            } else {
                endDate = 0L;
            }
        }
        catch (Exception e) {
            log.error("Error parsing end date", e);
            endDate = 0L;
        }
        return new DateRange(startTime, endDate);
    }

    private static long addYear(Calendar calendar, int year, long date) {
        calendar.setTimeInMillis(date);
        calendar.set(1, year);
        return calendar.getTimeInMillis();
    }

    private static long fixTime(Calendar calendar, long date) {
        calendar.setTimeInMillis(date);
        calendar.set(10, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTimeInMillis();
    }

    @NotNull
    public static Roadwork buildRoadwork(ServiceDescriptor serviceDescriptor, @NotNull Object node) {
        RoadworkBuilder roadworkBuilder = RoadworkBuilder.aRoadwork();
        roadworkBuilder.withId(DefaultJsonService.getPath(node, serviceDescriptor.getId()));
        try {
            String latitudePath = serviceDescriptor.getLatitude();
            if (latitudePath == null || latitudePath.isEmpty()) {
                log.warn("Unable to get latitude as it's path is empty");
            } else {
                roadworkBuilder.withLatitude(DefaultJsonService.getPathAsDouble(node, latitudePath));
            }
        }
        catch (Exception e) {
            log.warn("Unable to get latitude from {}, {}", node, (Object)e.getMessage());
        }
        try {
            String longitudePath = serviceDescriptor.getLongitude();
            if (longitudePath == null || longitudePath.isEmpty()) {
                log.warn("Unable to get longitude as it's path is empty");
            } else {
                roadworkBuilder.withLongitude(DefaultJsonService.getPathAsDouble(node, longitudePath));
            }
        }
        catch (Exception e) {
            log.warn("Unable to get longitude from {}, {}", node, (Object)e.getMessage());
        }
        if (serviceDescriptor.getRoad() != null) {
            roadworkBuilder.withRoad(DefaultJsonService.getPath(node, serviceDescriptor.getRoad()));
        }
        if (serviceDescriptor.getDescription() != null) {
            roadworkBuilder.withDescription(DefaultJsonService.getPath(node, serviceDescriptor.getDescription()));
        }
        if (serviceDescriptor.getLocationDetails() != null) {
            roadworkBuilder.withLocationDetails(DefaultJsonService.getPath(node, serviceDescriptor.getLocationDetails()));
        }
        try {
            DateRange dateRange = DefaultJsonService.getDateRange(node, serviceDescriptor);
            roadworkBuilder.withStart(dateRange.getFrom());
            roadworkBuilder.withEnd(dateRange.getTo());
        }
        catch (ParseException e) {
            log.error("Unable to parse date", e);
        }
        if (serviceDescriptor.getImpactCirculationDetail() != null) {
            roadworkBuilder.withImpactCirculationDetail(DefaultJsonService.getPath(node, serviceDescriptor.getImpactCirculationDetail()));
        }
        if (serviceDescriptor.getLocationDetails() != null) {
            roadworkBuilder.withLocationDetails(DefaultJsonService.getPath(node, serviceDescriptor.getLocationDetails()));
        }
        if (serviceDescriptor.getUrl() != null) {
            roadworkBuilder.withUrl(DefaultJsonService.getPath(node, serviceDescriptor.getUrl()));
        }
        return roadworkBuilder.build();
    }

    private static String getPath(Object node, String path) {
        try {
            Object value = JsonPath.read(node, path, new Predicate[0]);
            if (value != null) {
                return String.valueOf(value);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private static double getPathAsDouble(@NotNull Object node, @NotNull String path) throws ParseException {
        try {
            Objects.requireNonNull(path);
            Object value = JsonPath.read(node, path, new Predicate[0]);
            if (value instanceof Double) {
                return (Double)value;
            }
            return Double.parseDouble(String.valueOf(value).replace(',', '.'));
        }
        catch (Exception e) {
            log.error("Error parsing double", e);
            throw new ParseException("Unable to parse", 0);
        }
    }
}

