/*
 * Decompiled with CFR 0.152.
 */
package com.kpouer.roadwork.opendata.json.model;

import com.kpouer.roadwork.opendata.json.model.DateResult;
import com.kpouer.roadwork.opendata.json.model.Parser;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class DateParser {
    private String path;
    private List<Parser> parsers;

    public String getPath() {
        return this.path;
    }

    public List<Parser> getParsers() {
        return this.parsers;
    }

    public DateResult parse(@NotNull String value, Locale locale) throws ParseException {
        for (Parser parser : this.parsers) {
            long timestamp;
            Matcher match = parser.match(value);
            if (!match.matches()) continue;
            String str = match.groupCount() == 1 ? match.group(1) : match.group(0);
            String format = parser.getFormat();
            if (format == null) {
                timestamp = Long.parseLong(str);
                if (timestamp < 1000000000000L) {
                    timestamp *= 1000L;
                }
            } else {
                timestamp = this.parseDate(format, str, locale);
            }
            return new DateResult(timestamp, parser);
        }
        throw new ParseException("Unable to parse date '" + value + "' with parsers :" + this.toStringParsers(), 0);
    }

    private String toStringParsers() {
        return this.parsers.stream().map(Parser::getFormat).collect(Collectors.joining("|"));
    }

    private long parseDate(String pattern, String value, Locale locale) throws ParseException {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(pattern, locale);
        Date date = simpleDateFormat.parse(value);
        return date.getTime();
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setParsers(List<Parser> parsers) {
        this.parsers = parsers;
    }
}

