/*
 * Decompiled with CFR 0.152.
 */
package com.kpouer.roadwork.opendata.json.model;

import com.kpouer.mapview.LatLng;
import com.kpouer.roadwork.opendata.json.model.Metadata;

public class MetadataBuilder {
    private String country;
    private LatLng center;
    private String source_url;
    private String url;
    private String name;
    private String producer;
    private String licenceName;
    private String licenceUrl;

    private MetadataBuilder() {
    }

    public static MetadataBuilder aMetadata() {
        return new MetadataBuilder();
    }

    public MetadataBuilder withCountry(String country) {
        this.country = country;
        return this;
    }

    public MetadataBuilder withCenter(double latitude, double longitude) {
        this.center = new LatLng(latitude, longitude);
        return this;
    }

    public MetadataBuilder withSource_url(String source_url) {
        this.source_url = source_url;
        return this;
    }

    public MetadataBuilder withUrl(String url) {
        this.url = url;
        return this;
    }

    public MetadataBuilder withName(String name) {
        this.name = name;
        return this;
    }

    public MetadataBuilder withProducer(String producer) {
        this.producer = producer;
        return this;
    }

    public MetadataBuilder withLicenceName(String licenceName) {
        this.licenceName = licenceName;
        return this;
    }

    public MetadataBuilder withLicenceUrl(String licenceUrl) {
        this.licenceUrl = licenceUrl;
        return this;
    }

    public Metadata build() {
        Metadata metadata = new Metadata();
        metadata.setCountry(this.country);
        metadata.setCenter(this.center);
        metadata.setSourceUrl(this.source_url);
        metadata.setUrl(this.url);
        metadata.setName(this.name);
        metadata.setProducer(this.producer);
        metadata.setLicenceName(this.licenceName);
        metadata.setLicenceUrl(this.licenceUrl);
        return metadata;
    }
}

