/*
 * Decompiled with CFR 0.152.
 */
package com.kpouer.roadwork.service;

import javax.swing.JComponent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.MessageSource;
import org.springframework.context.NoSuchMessageException;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.lang.Nullable;
import org.springframework.stereotype.Service;

@Service
public class LocalizationService {
    private static final Logger logger = LoggerFactory.getLogger(LocalizationService.class);
    private final MessageSource resourceBundle;

    public LocalizationService() {
        ResourceBundleMessageSource resourceBundle = new ResourceBundleMessageSource();
        resourceBundle.setBasenames("messages");
        resourceBundle.setUseCodeAsDefaultMessage(true);
        this.resourceBundle = resourceBundle;
    }

    public String getMessage(String code, @Nullable Object[] args) {
        try {
            return this.resourceBundle.getMessage(code, args, JComponent.getDefaultLocale());
        }
        catch (NoSuchMessageException e) {
            logger.error("Unable to get message {}", (Object)code);
            return code;
        }
    }

    public String getMessage(String code) {
        try {
            return this.resourceBundle.getMessage(code, null, JComponent.getDefaultLocale());
        }
        catch (NoSuchMessageException e) {
            logger.error("Unable to get message {}", (Object)code);
            return code;
        }
    }
}

