/*
 * Decompiled with CFR 0.152.
 */
package com.kpouer.roadwork.service;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.kpouer.mapview.LatLng;
import com.kpouer.mapview.tile.TileServer;
import com.kpouer.roadwork.configuration.Config;
import com.kpouer.roadwork.model.Roadwork;
import com.kpouer.roadwork.model.RoadworkData;
import com.kpouer.roadwork.model.sync.Status;
import com.kpouer.roadwork.opendata.OpendataService;
import com.kpouer.roadwork.opendata.json.DefaultJsonService;
import com.kpouer.roadwork.opendata.json.model.ServiceDescriptor;
import com.kpouer.roadwork.service.HttpService;
import com.kpouer.roadwork.service.ResourceService;
import com.kpouer.roadwork.service.RoadworkMigrationService;
import com.kpouer.roadwork.service.SynchronizationService;
import com.kpouer.roadwork.service.exception.OpenDataException;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestClientException;

@Service
public class OpendataServiceManager {
    private static final Logger log = LoggerFactory.getLogger(OpendataServiceManager.class);
    private static final String VERSION = "2";
    private final HttpService httpService;
    private final Config config;
    private final ApplicationContext applicationContext;
    private final SynchronizationService synchronizationService;
    private final ResourceService resourceService;

    public List<String> getServices() {
        log.info("getServices");
        List<String> services = this.getDefaultServices();
        List<String> thirdPartyServices = this.getThirdPartyServices();
        ArrayList<String> allServices = new ArrayList<String>(services.size() + thirdPartyServices.size());
        allServices.addAll(services);
        allServices.addAll(thirdPartyServices);
        return allServices;
    }

    public List<String> getDefaultServices() {
        log.info("getDefaultServices");
        List<String> services = this.getServicesFromPath("opendata/json/");
        services.forEach(service -> log.info("Default service : " + service));
        return services;
    }

    public List<String> getThirdPartyServices() {
        log.info("getThirdPartyServices");
        List<String> services = this.getServicesFromPath("thirdparty");
        services.forEach(service -> log.info("Third party service : " + service));
        return services;
    }

    private List<String> getServicesFromPath(String folder) {
        block10: {
            List<String> list;
            block9: {
                Path pathFolder = Path.of(folder, new String[0]);
                log.info("getServicesFromPath {}", (Object)pathFolder.toAbsolutePath());
                Stream<Path> files = Files.list(pathFolder);
                try {
                    List<String> services = files.filter(path -> path.toString().endsWith(".json")).map(Path::toFile).map(File::getName).toList();
                    services.forEach(service -> log.info("Disk service {}/{}", (Object)folder, service));
                    list = services;
                    if (files == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (files != null) {
                            try {
                                files.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (NoSuchFileException e) {
                        log.info("Path {} do not exist", (Object)pathFolder.toAbsolutePath());
                        break block10;
                    }
                    catch (IOException e) {
                        log.error("Unable to read opendata services", e);
                    }
                }
                files.close();
            }
            return list;
        }
        return Collections.emptyList();
    }

    public Optional<RoadworkData> getData() throws RestClientException, IOException, OpenDataException {
        Optional<RoadworkData> roadworks = this.getRoadworks();
        roadworks.ifPresent(roadworkData -> {
            OpendataServiceManager.applyFinishedStatus(roadworkData);
            this.synchronizationService.synchronize((RoadworkData)roadworkData);
        });
        return roadworks;
    }

    public void save(RoadworkData roadworkData) {
        log.info("save {}", (Object)roadworkData.getSource());
        ObjectMapper objectMapper = new ObjectMapper();
        Path savePath = this.getPath(roadworkData.getSource());
        try {
            Files.createDirectories(savePath.getParent(), new FileAttribute[0]);
            Files.write(savePath, objectMapper.writeValueAsBytes(roadworkData), new OpenOption[0]);
        }
        catch (IOException e) {
            log.error("Unable to save cache to {}", (Object)savePath);
        }
    }

    public LatLng getCenter() {
        try {
            return this.getOpendataService().getMetadata().getCenter();
        }
        catch (OpenDataException e) {
            return new LatLng(48.85337, 2.34847);
        }
    }

    @NotNull
    private Optional<RoadworkData> getRoadworks() throws RestClientException, IOException, OpenDataException {
        Path currentPath = this.getPath(this.config.getOpendataService());
        log.info("getData {}", (Object)currentPath);
        Optional<RoadworkData> cachedDataOptional = this.loadCache(currentPath);
        if (cachedDataOptional.isEmpty()) {
            log.info("There is no cached data");
            Optional<RoadworkData> newData = this.getOpendataService().getData();
            newData.ifPresent(this::save);
            return newData;
        }
        RoadworkData cachedRoadworkData = cachedDataOptional.get();
        if (cachedRoadworkData.getCreated() + 86400000L < System.currentTimeMillis()) {
            log.info("Cache is obsolete {}", (Object)currentPath);
            Files.delete(currentPath);
            Optional<RoadworkData> newDataOptional = this.getOpendataService().getData();
            if (newDataOptional.isPresent()) {
                RoadworkData newData = newDataOptional.get();
                Map<String, Roadwork> newRoadworks = newData.getRoadworks();
                log.info("reloaded {} new roadworks", (Object)newRoadworks.size());
                for (Roadwork existingRoadwork : cachedRoadworkData) {
                    Roadwork newRoadwork = newRoadworks.get(existingRoadwork.getId());
                    if (newRoadwork == null) continue;
                    log.info("Roadwork {} -> status {}", (Object)existingRoadwork.getId(), (Object)existingRoadwork.getSyncData().getStatus());
                    newRoadwork.getSyncData().copy(existingRoadwork.getSyncData());
                    existingRoadwork.updateMarker();
                }
                this.save(newData);
            }
            return newDataOptional;
        }
        return cachedDataOptional;
    }

    @NotNull
    public OpendataService getOpendataService() throws OpenDataException {
        log.debug("getOpendataService");
        String opendataService = this.config.getOpendataService();
        return this.getOpendataService(opendataService);
    }

    public TileServer getTileServer() {
        String tileServerName;
        try {
            tileServerName = this.getOpendataService().getMetadata().getTileServer();
        }
        catch (OpenDataException e) {
            return this.config.getWazeINTLTileServer();
        }
        try {
            return this.applicationContext.getBean(tileServerName + "TileServer", TileServer.class);
        }
        catch (BeansException e) {
            log.error("Error getting tile server " + tileServerName, e);
            return this.config.getWazeINTLTileServer();
        }
    }

    @NotNull
    public OpendataService getOpendataService(String opendataService) throws OpenDataException {
        log.info("getOpendataService {}", (Object)opendataService);
        if (opendataService.endsWith(".json")) {
            return this.getJsonService(opendataService);
        }
        try {
            return this.applicationContext.getBean(opendataService, OpendataService.class);
        }
        catch (NoSuchBeanDefinitionException e) {
            throw new OpenDataException(e.getMessage(), e);
        }
    }

    @NotNull
    private DefaultJsonService getJsonService(String opendataService) throws OpenDataException {
        log.info("getJsonService {}", (Object)opendataService);
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            Optional<URL> opendataServicePath = this.resourceService.getResource(opendataService);
            if (opendataServicePath.isPresent()) {
                ServiceDescriptor serviceDescriptor = objectMapper.readValue(opendataServicePath.get(), ServiceDescriptor.class);
                return new DefaultJsonService(opendataService, this.httpService, serviceDescriptor);
            }
        }
        catch (IOException e) {
            throw new OpenDataException("Unable to find service " + opendataService, e);
        }
        throw new OpenDataException("Unable to find service " + opendataService);
    }

    @NotNull
    private Path getPath(String opendataService) {
        return Path.of(this.config.getDataPath(), opendataService + ".2.json");
    }

    private Optional<RoadworkData> loadCache(Path cachePath) {
        if (Files.exists(cachePath, new LinkOption[0])) {
            ObjectMapper objectMapper = new ObjectMapper();
            objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            try {
                RoadworkData roadworkData = objectMapper.readValue(cachePath.toFile(), RoadworkData.class);
                log.info("Cache loaded");
                return Optional.of(roadworkData);
            }
            catch (IOException e) {
                log.error("Unable to load cache {} {}", (Object)cachePath, (Object)e);
            }
        } else {
            return this.getMigratedData();
        }
        return Optional.empty();
    }

    private Optional<RoadworkData> getMigratedData() {
        log.info("There is no cache, checking if there is old data");
        Map<String, RoadworkMigrationService> beansOfType = this.applicationContext.getBeansOfType(RoadworkMigrationService.class);
        Collection<RoadworkMigrationService> migrationServices = beansOfType.values();
        for (RoadworkMigrationService migrationService : migrationServices) {
            Optional<RoadworkData> roadworkData = migrationService.migrateData();
            if (!roadworkData.isPresent()) continue;
            log.info("Migrating service {}", (Object)migrationService);
            migrationService.archive();
            this.save(roadworkData.get());
            return roadworkData;
        }
        return Optional.empty();
    }

    private static void applyFinishedStatus(RoadworkData roadworkData) {
        roadworkData.getRoadworks().values().stream().filter(Roadwork::isExpired).map(Roadwork::getSyncData).forEach(syncData -> syncData.setStatus(Status.Finished));
    }

    public void deleteCache() {
        log.info("deleteCache {}", (Object)this.config.getOpendataService());
        Path currentPath = this.getPath(this.config.getOpendataService());
        try {
            Files.deleteIfExists(currentPath);
        }
        catch (IOException e) {
            log.error("Error deleting cache", e);
        }
    }

    public OpendataServiceManager(HttpService httpService, Config config, ApplicationContext applicationContext, SynchronizationService synchronizationService, ResourceService resourceService) {
        this.httpService = httpService;
        this.config = config;
        this.applicationContext = applicationContext;
        this.synchronizationService = synchronizationService;
        this.resourceService = resourceService;
    }
}

