/*
 * Decompiled with CFR 0.152.
 */
package com.kpouer.roadwork.service;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ResourceService {
    private static final Logger log = LoggerFactory.getLogger(ResourceService.class);
    public static final String OPENDATA_JSON = "opendata/json/";
    public static final String THIRDPARTY = "thirdparty";

    List<String> listFilesFromClasspath(String path) throws URISyntaxException, IOException {
        log.debug("listFiles {}", (Object)path);
        URL dirURL = this.getClass().getClassLoader().getResource(path);
        if (dirURL == null) {
            return Collections.emptyList();
        }
        if (dirURL.getProtocol().equals("file")) {
            return List.of(new File(dirURL.toURI()).list());
        }
        if (dirURL.getProtocol().equals("jar")) {
            String jarPath = dirURL.getPath().substring(5, dirURL.getPath().indexOf("!"));
            try (JarFile jar = new JarFile(URLDecoder.decode(jarPath, StandardCharsets.UTF_8));){
                List<String> list;
                block14: {
                    Stream<JarEntry> stream = jar.stream();
                    try {
                        list = stream.map(ZipEntry::getName).filter(entryName -> entryName.startsWith(path)).filter(entryName -> entryName.lastIndexOf(47) <= path.length()).toList();
                        if (stream == null) break block14;
                    }
                    catch (Throwable throwable) {
                        if (stream != null) {
                            try {
                                stream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    stream.close();
                }
                return list;
            }
        }
        log.error("Unable to list files under path {}", (Object)path);
        return Collections.emptyList();
    }

    public Optional<URL> getResource(String filename) {
        log.info("getResource {}", (Object)filename);
        Optional<URL> thirdParty = this.getFile(THIRDPARTY, filename);
        if (thirdParty.isPresent()) {
            return thirdParty;
        }
        Optional<URL> file = this.getFile(OPENDATA_JSON, filename);
        if (file.isPresent()) {
            return file;
        }
        log.warn("Resource not found");
        return Optional.empty();
    }

    private Optional<URL> getFile(String parentPath, String filename) {
        try {
            Path path = Path.of(parentPath, filename);
            if (Files.exists(path, new LinkOption[0])) {
                log.info("Found resource with url");
                URL url = path.toUri().toURL();
                return Optional.of(url);
            }
        }
        catch (MalformedURLException e) {
            log.error(e.getMessage(), e);
        }
        return Optional.empty();
    }
}

