/*
 * Decompiled with CFR 0.152.
 */
package com.kpouer.roadwork.ui;

import com.kpouer.mapview.MapView;
import com.kpouer.roadwork.action.WmeAction;
import com.kpouer.roadwork.configuration.Config;
import com.kpouer.roadwork.model.Roadwork;
import com.kpouer.roadwork.model.sync.Status;
import com.kpouer.roadwork.service.LocalizationService;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.EnumMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import net.miginfocom.swing.MigLayout;

@org.springframework.stereotype.Component
public class DetailPanel
extends JPanel {
    private final JTextField id;
    private final JTextField location;
    private final JTextField start;
    private final JTextField stop;
    private final JTextField road;
    private final JTextField locationDetails;
    private final JTextArea circulationDetail;
    private final JTextArea description;
    private final Config config;
    private final MapView mapView;
    private final Map<Status, JRadioButton> statusRadioButtons;
    private Roadwork roadwork;
    private JButton urlDetails;

    public DetailPanel(Config config, MapView mapView, LocalizationService localizationService, WmeAction wmeAction) {
        super(new MigLayout());
        this.config = config;
        this.mapView = mapView;
        this.id = new JTextField(40);
        this.add((Component)this.id, "wrap, span 3");
        this.location = new JTextField(40);
        this.add((Component)this.location, "span 2");
        this.add((Component)new JButton(wmeAction), "wrap");
        this.start = new JTextField(40);
        this.add(this.start);
        this.stop = new JTextField(40);
        this.add((Component)this.stop, "wrap, span 3");
        this.road = new JTextField(40);
        this.add((Component)this.road, "wrap, span 3");
        this.locationDetails = new JTextField(40);
        this.add((Component)this.locationDetails, "wrap, span 32");
        this.circulationDetail = new JTextArea(3, 40);
        JScrollPane circulationDetailsScroll = new JScrollPane(this.circulationDetail);
        this.add((Component)circulationDetailsScroll, "wrap, span 3");
        this.description = new JTextArea(3, 40);
        JScrollPane descriptionScroll = new JScrollPane(this.description);
        this.add((Component)descriptionScroll, "wrap, span 3");
        this.urlDetails = new JButton(localizationService.getMessage("detailPanel.openUrl"));
        this.add((Component)this.urlDetails, "wrap");
        this.urlDetails.setEnabled(false);
        this.urlDetails.addActionListener(e -> {
            if (Desktop.isDesktopSupported() && Desktop.getDesktop().isSupported(Desktop.Action.BROWSE)) {
                try {
                    Desktop.getDesktop().browse(new URI(this.roadwork.getUrl()));
                }
                catch (IOException | URISyntaxException ex) {
                    throw new RuntimeException(ex);
                }
            }
        });
        this.id.setBorder(BorderFactory.createTitledBorder("id"));
        this.location.setBorder(BorderFactory.createTitledBorder(localizationService.getMessage("detailPanel.location")));
        this.start.setBorder(BorderFactory.createTitledBorder(localizationService.getMessage("detailPanel.start")));
        this.stop.setBorder(BorderFactory.createTitledBorder(localizationService.getMessage("detailPanel.end")));
        this.road.setBorder(BorderFactory.createTitledBorder(localizationService.getMessage("detailPanel.road")));
        this.locationDetails.setBorder(BorderFactory.createTitledBorder(localizationService.getMessage("detailPanel.locationDetail")));
        circulationDetailsScroll.setBorder(BorderFactory.createTitledBorder(localizationService.getMessage("detailPanel.impact")));
        this.circulationDetail.setLineWrap(true);
        this.description.setLineWrap(true);
        descriptionScroll.setBorder(BorderFactory.createTitledBorder(localizationService.getMessage("detailPanel.description")));
        this.statusRadioButtons = new EnumMap<Status, JRadioButton>(Status.class);
        ButtonGroup statusGroup = new ButtonGroup();
        Status[] values = Status.values();
        for (int i = 0; i < values.length; ++i) {
            Status status = values[i];
            JRadioButton radioButton = new JRadioButton(localizationService.getMessage("enum.status." + status));
            statusGroup.add(radioButton);
            radioButton.addActionListener(new StatusChangeAction(status));
            this.statusRadioButtons.put(status, radioButton);
            if ((i + 1) % 2 == 0) {
                this.add((Component)radioButton, "wrap");
                continue;
            }
            this.add(radioButton);
        }
        this.circulationDetail.setWrapStyleWord(true);
        this.description.setWrapStyleWord(true);
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(400, -1);
    }

    public void setRoadwork(Roadwork roadwork) {
        this.roadwork = roadwork;
        this.id.setText(roadwork.getId());
        this.location.setText(roadwork.getLatitude() + "," + roadwork.getLongitude());
        SimpleDateFormat format = new SimpleDateFormat(this.config.getDatePattern());
        this.start.setText(format.format(new Date(roadwork.getStart())));
        this.stop.setText(format.format(new Date(roadwork.getEnd())));
        this.road.setText(roadwork.getRoad());
        this.road.setCaretPosition(0);
        this.locationDetails.setText(roadwork.getLocationDetails());
        this.locationDetails.setCaretPosition(0);
        this.circulationDetail.setText(roadwork.getImpactCirculationDetail());
        this.circulationDetail.setCaretPosition(0);
        this.description.setText(roadwork.getDescription());
        this.description.setWrapStyleWord(true);
        this.statusRadioButtons.get((Object)roadwork.getSyncData().getStatus()).setSelected(true);
        this.urlDetails.setEnabled(roadwork.getUrl() != null);
    }

    private class StatusChangeAction
    implements ActionListener {
        private final Status status;

        private StatusChangeAction(Status status) {
            this.status = status;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (DetailPanel.this.roadwork != null) {
                DetailPanel.this.roadwork.getSyncData().setStatus(this.status);
                DetailPanel.this.roadwork.updateStatus(this.status);
                DetailPanel.this.mapView.repaint();
            }
        }
    }
}

