/*
 * Decompiled with CFR 0.152.
 */
package com.kpouer.roadwork.ui.descriptorhelper;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.InvalidPathException;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import com.kpouer.roadwork.model.Roadwork;
import com.kpouer.roadwork.opendata.json.DefaultJsonService;
import com.kpouer.roadwork.opendata.json.model.DateParser;
import com.kpouer.roadwork.opendata.json.model.Metadata;
import com.kpouer.roadwork.opendata.json.model.Parser;
import com.kpouer.roadwork.opendata.json.model.ServiceDescriptor;
import com.kpouer.roadwork.service.LocalizationService;
import com.kpouer.roadwork.ui.MainPanel;
import java.awt.Color;
import java.awt.EventQueue;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.swing.BorderFactory;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import net.miginfocom.swing.MigLayout;
import net.minidev.json.JSONArray;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rsyntaxtextarea.TextEditorPane;
import org.fife.ui.rtextarea.RTextScrollPane;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Lazy;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestTemplate;

@Component
@Lazy
@Scope(value="prototype")
public class DescriptorHelperDialog
extends JDialog {
    private static final Logger logger = LoggerFactory.getLogger(DescriptorHelperDialog.class);
    private final JTextField urlTextField;
    private final RSyntaxTextArea editor;
    private final RSyntaxTextArea sampleTextArea;
    private final RSyntaxTextArea preview;
    private final RSyntaxTextArea roadworkPreview;
    private final LocalizationService localizationService;
    private final Color defaultColor;
    private Object sample;
    private final ObjectWriter objectWriter;
    private final ObjectMapper objectMapper;
    private ServiceDescriptor serviceDescriptor;
    private String currentRoadworkPath;
    private Object currentRoadwork;
    private Color ERROR_COLOR = new Color(255, 0, 0, 30);

    public DescriptorHelperDialog(MainPanel parent, LocalizationService localizationService) {
        super(parent);
        this.objectMapper = new ObjectMapper();
        this.localizationService = localizationService;
        this.objectWriter = new ObjectMapper().setDefaultPropertyInclusion(JsonInclude.Include.ALWAYS).writerWithDefaultPrettyPrinter();
        this.serviceDescriptor = DescriptorHelperDialog.createDefaultServiceDescriptor();
        JPanel topPanel = new JPanel(new MigLayout());
        topPanel.add(new JLabel("url"));
        this.urlTextField = new JTextField(80);
        topPanel.add((java.awt.Component)this.urlTextField, "growx");
        this.getContentPane().add((java.awt.Component)topPanel, "First");
        this.sampleTextArea = DescriptorHelperDialog.createTextArea();
        RTextScrollPane sampleScrollPane = new RTextScrollPane(this.sampleTextArea);
        sampleScrollPane.setBorder(BorderFactory.createTitledBorder("Sample"));
        this.roadworkPreview = DescriptorHelperDialog.createTextArea();
        RTextScrollPane roadworkScrollPane = new RTextScrollPane(this.roadworkPreview);
        roadworkScrollPane.setBorder(BorderFactory.createTitledBorder("Roadwork"));
        JSplitPane rightSplitPane = new JSplitPane(0, sampleScrollPane, roadworkScrollPane);
        rightSplitPane.setDividerLocation(0.5);
        this.editor = DescriptorHelperDialog.createTextArea();
        RTextScrollPane editorScrollPane = new RTextScrollPane(this.editor);
        this.preview = DescriptorHelperDialog.createTextArea();
        RTextScrollPane previewScrollPanel = new RTextScrollPane(this.preview);
        previewScrollPanel.setBorder(BorderFactory.createTitledBorder("Preview"));
        this.getContentPane().add(new JSplitPane(0, new JSplitPane(1, editorScrollPane, rightSplitPane), previewScrollPanel));
        this.sampleTextArea.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                EventQueue.invokeLater(() -> DescriptorHelperDialog.this.sampleUpdated());
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                EventQueue.invokeLater(() -> DescriptorHelperDialog.this.sampleUpdated());
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
            }
        });
        this.editor.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                EventQueue.invokeLater(() -> DescriptorHelperDialog.this.updated());
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                EventQueue.invokeLater(() -> DescriptorHelperDialog.this.updated());
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
            }
        });
        try {
            this.editor.setText(this.objectWriter.writeValueAsString(this.serviceDescriptor));
        }
        catch (JsonProcessingException e2) {
            logger.error("Error processing json", e2);
        }
        this.defaultColor = this.editor.getBackground();
        this.setSize(1024, 768);
        this.urlTextField.addActionListener(e -> this.callUrl());
    }

    private static ServiceDescriptor createDefaultServiceDescriptor() {
        ServiceDescriptor serviceDescriptor = new ServiceDescriptor();
        serviceDescriptor.setMetadata(new Metadata());
        serviceDescriptor.setRoadworkArray("$.records");
        serviceDescriptor.setId("@.recordid");
        serviceDescriptor.setLatitude("@.geometry.coordinates[1]");
        serviceDescriptor.setLongitude("@.geometry.coordinates[0]");
        DateParser from = new DateParser();
        ArrayList<Parser> parsers = new ArrayList<Parser>();
        Parser parser = new Parser();
        parser.setMatcher(".*");
        parser.setFormat("yyyy-MM-dd");
        parsers.add(parser);
        from.setParsers(parsers);
        serviceDescriptor.setFrom(from);
        serviceDescriptor.setTo(from);
        return serviceDescriptor;
    }

    private void updated() {
        logger.debug("updated");
        try {
            this.serviceDescriptor = this.objectMapper.readValue(this.editor.getText(), ServiceDescriptor.class);
            String roadworkArray = this.serviceDescriptor.getRoadworkArray();
            if (!Objects.equals(roadworkArray, this.currentRoadworkPath)) {
                this.currentRoadworkPath = roadworkArray;
                Optional<Object> nodeOptional = this.getRoadworkArrayNode();
                if (nodeOptional.isEmpty()) {
                    logger.error("Unable to get a sample roadwork");
                    return;
                }
                this.currentRoadwork = nodeOptional.get();
                this.roadworkPreview.setText(this.objectWriter.writeValueAsString(this.currentRoadwork));
                this.roadworkPreview.setCaretPosition(0);
            }
            if (this.currentRoadwork == null) {
                return;
            }
            Roadwork roadwork = DefaultJsonService.buildRoadwork(this.serviceDescriptor, this.currentRoadwork);
            this.preview.setText(this.objectWriter.writeValueAsString(roadwork));
            this.preview.setCaretPosition(0);
            this.editor.setBackground(this.defaultColor);
        }
        catch (InvalidPathException e) {
            this.editor.setBackground(this.ERROR_COLOR);
            logger.warn("Invalid path {}", (Object)e.getMessage());
        }
        catch (JsonProcessingException e) {
            logger.error("Error processing json", e);
            this.editor.setBackground(this.ERROR_COLOR);
        }
        catch (Exception e) {
            logger.error("Error processing", e);
            this.editor.setBackground(this.ERROR_COLOR);
        }
    }

    private Optional<Object> getRoadworkArrayNode() {
        if (this.sample == null) {
            return Optional.empty();
        }
        String roadworkArrayPath = this.serviceDescriptor.getRoadworkArray();
        if (roadworkArrayPath == null || roadworkArrayPath.trim().isEmpty()) {
            logger.debug("Roadwork array path cannot be null or empty");
            this.editor.setBackground(this.ERROR_COLOR);
            return Optional.empty();
        }
        try {
            JSONArray roadworkArray = (JSONArray)JsonPath.read(this.sample, roadworkArrayPath, new Predicate[0]);
            return Optional.of(roadworkArray.get(0));
        }
        catch (ClassCastException e) {
            logger.error("Not an array");
            return Optional.empty();
        }
    }

    @NotNull
    private static RSyntaxTextArea createTextArea() {
        TextEditorPane textArea = new TextEditorPane(0, false);
        textArea.setSyntaxEditingStyle("text/json");
        textArea.setCodeFoldingEnabled(true);
        return textArea;
    }

    private void callUrl() {
        String url = this.urlTextField.getText().trim();
        logger.info("callUrl {}", (Object)url);
        RestTemplate restTemplate = new RestTemplate();
        try {
            ObjectNode json = restTemplate.getForObject(new URI(url), ObjectNode.class);
            String jsonString = this.objectWriter.writeValueAsString(json);
            this.sampleTextArea.setText(jsonString);
            this.sampleTextArea.setCaretPosition(0);
            this.sampleUpdated();
        }
        catch (URISyntaxException e) {
            JOptionPane.showMessageDialog(this, "Invalid url");
        }
        catch (JsonProcessingException e) {
            logger.error("Error", e);
        }
    }

    private void sampleUpdated() {
        try {
            logger.debug("sampleUpdated");
            String jsonString = this.sampleTextArea.getText();
            this.sample = Configuration.defaultConfiguration().jsonProvider().parse(jsonString);
            this.currentRoadworkPath = null;
            this.currentRoadwork = null;
            this.updated();
        }
        catch (Throwable e) {
            logger.error("Error", e);
        }
    }
}

