/*
 * Decompiled with CFR 0.152.
 */
package com.kpouer.roadwork.ui.logpanel;

import com.kpouer.roadwork.ui.MainPanel;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.springframework.context.annotation.Lazy;
import org.springframework.context.annotation.Scope;

@org.springframework.stereotype.Component
@Lazy
@Scope(value="prototype")
public class LogPanelDialog
extends JDialog {
    public LogPanelDialog(MainPanel parent, final List<String> logs) {
        super(parent);
        final JList<String> list = new JList<String>(new AbstractListModel<String>(){

            @Override
            public int getSize() {
                return logs.size();
            }

            @Override
            public String getElementAt(int index) {
                return (String)logs.get(index);
            }
        });
        list.setSelectionMode(1);
        this.add(new JScrollPane(list));
        this.setSize(1024, 768);
        JPanel toolbarPanel = new JPanel(new FlowLayout(3));
        JButton copy = new JButton("Copy");
        toolbarPanel.add(copy);
        copy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StringBuilder builder = new StringBuilder(10000);
                list.getSelectedValuesList().forEach(line -> builder.append((String)line).append('\n'));
                Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(builder.toString()), null);
            }
        });
        this.getContentPane().add((Component)toolbarPanel, "North");
    }
}

