/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.server.reactive;

import jakarta.servlet.AsyncContext;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletRequestWrapper;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpServletResponseWrapper;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.server.HttpOutput;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.http.server.reactive.HttpHandler;
import org.springframework.http.server.reactive.JettyHeadersAdapter;
import org.springframework.http.server.reactive.ServletHttpHandlerAdapter;
import org.springframework.http.server.reactive.ServletServerHttpRequest;
import org.springframework.http.server.reactive.ServletServerHttpResponse;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.MultiValueMap;

public class JettyHttpHandlerAdapter
extends ServletHttpHandlerAdapter {
    private static final boolean jetty11Present = ClassUtils.isPresent("org.eclipse.jetty.server.HttpOutput", JettyHttpHandlerAdapter.class.getClassLoader());

    public JettyHttpHandlerAdapter(HttpHandler httpHandler) {
        super(httpHandler);
    }

    @Override
    protected ServletServerHttpRequest createRequest(HttpServletRequest request, AsyncContext context) throws IOException, URISyntaxException {
        if (jetty11Present) {
            Assert.state(this.getServletPath() != null, "Servlet path is not initialized");
            return new Jetty11ServerHttpRequest(request, context, this.getServletPath(), this.getDataBufferFactory(), this.getBufferSize());
        }
        return super.createRequest(request, context);
    }

    @Override
    protected ServletServerHttpResponse createResponse(HttpServletResponse response, AsyncContext context, ServletServerHttpRequest request) throws IOException {
        if (jetty11Present) {
            return new Jetty11ServerHttpResponse(response, context, this.getDataBufferFactory(), this.getBufferSize(), request);
        }
        return super.createResponse(response, context, request);
    }

    private static final class Jetty11ServerHttpRequest
    extends ServletServerHttpRequest {
        Jetty11ServerHttpRequest(HttpServletRequest request, AsyncContext asyncContext, String servletPath, DataBufferFactory bufferFactory, int bufferSize) throws IOException, URISyntaxException {
            super(Jetty11ServerHttpRequest.createHeaders(request), request, asyncContext, servletPath, bufferFactory, bufferSize);
        }

        private static MultiValueMap<String, String> createHeaders(HttpServletRequest servletRequest) {
            Request request = Jetty11ServerHttpRequest.getRequest(servletRequest);
            return new JettyHeadersAdapter(HttpFields.build((HttpFields)request.getHttpFields()));
        }

        private static Request getRequest(HttpServletRequest request) {
            if (request instanceof Request) {
                Request jettyRequest = (Request)request;
                return jettyRequest;
            }
            if (request instanceof HttpServletRequestWrapper) {
                HttpServletRequestWrapper wrapper = (HttpServletRequestWrapper)request;
                HttpServletRequest wrappedRequest = (HttpServletRequest)wrapper.getRequest();
                return Jetty11ServerHttpRequest.getRequest(wrappedRequest);
            }
            throw new IllegalArgumentException("Cannot convert [" + request.getClass() + "] to org.eclipse.jetty.server.Request");
        }
    }

    private static final class Jetty11ServerHttpResponse
    extends ServletServerHttpResponse {
        Jetty11ServerHttpResponse(HttpServletResponse response, AsyncContext asyncContext, DataBufferFactory bufferFactory, int bufferSize, ServletServerHttpRequest request) throws IOException {
            super(Jetty11ServerHttpResponse.createHeaders(response), response, asyncContext, bufferFactory, bufferSize, request);
        }

        private static HttpHeaders createHeaders(HttpServletResponse servletResponse) {
            Response response = Jetty11ServerHttpResponse.getResponse(servletResponse);
            return new HttpHeaders(new JettyHeadersAdapter(response.getHttpFields()));
        }

        private static Response getResponse(HttpServletResponse response) {
            if (response instanceof Response) {
                Response jettyResponse = (Response)response;
                return jettyResponse;
            }
            if (response instanceof HttpServletResponseWrapper) {
                HttpServletResponseWrapper wrapper = (HttpServletResponseWrapper)response;
                HttpServletResponse wrappedResponse = (HttpServletResponse)wrapper.getResponse();
                return Jetty11ServerHttpResponse.getResponse(wrappedResponse);
            }
            throw new IllegalArgumentException("Cannot convert [" + response.getClass() + "] to org.eclipse.jetty.server.Response");
        }

        @Override
        protected int writeToOutputStream(DataBuffer dataBuffer) throws IOException {
            ServletOutputStream output = this.getOutputStream();
            if (output instanceof HttpOutput) {
                HttpOutput httpOutput = (HttpOutput)output;
                ByteBuffer input = dataBuffer.toByteBuffer();
                int len = input.remaining();
                httpOutput.write(input);
                return len;
            }
            return super.writeToOutputStream(dataBuffer);
        }

        @Override
        protected void applyHeaders() {
            this.adaptHeaders(false);
        }
    }
}

